/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.io.unserialize;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.UUID;
import net.hasor.rsf.hprose.common.HproseException;
import net.hasor.rsf.hprose.io.ByteBufferStream;
import net.hasor.rsf.hprose.io.HproseClassManager;
import net.hasor.rsf.hprose.io.HproseMode;
import net.hasor.rsf.hprose.io.convert.DefaultConverter;
import net.hasor.rsf.hprose.io.unserialize.BigDecimalArrayUnserializer;
import net.hasor.rsf.hprose.io.unserialize.BigDecimalUnserializer;
import net.hasor.rsf.hprose.io.unserialize.BigIntegerArrayUnserializer;
import net.hasor.rsf.hprose.io.unserialize.BigIntegerUnserializer;
import net.hasor.rsf.hprose.io.unserialize.BooleanArrayUnserializer;
import net.hasor.rsf.hprose.io.unserialize.BooleanObjectUnserializer;
import net.hasor.rsf.hprose.io.unserialize.BooleanUnserializer;
import net.hasor.rsf.hprose.io.unserialize.ByteArrayUnserializer;
import net.hasor.rsf.hprose.io.unserialize.ByteObjectUnserializer;
import net.hasor.rsf.hprose.io.unserialize.ByteUnserializer;
import net.hasor.rsf.hprose.io.unserialize.BytesArrayUnserializer;
import net.hasor.rsf.hprose.io.unserialize.CalendarArrayUnserializer;
import net.hasor.rsf.hprose.io.unserialize.CalendarUnserializer;
import net.hasor.rsf.hprose.io.unserialize.CharArrayUnserializer;
import net.hasor.rsf.hprose.io.unserialize.CharObjectUnserializer;
import net.hasor.rsf.hprose.io.unserialize.CharUnserializer;
import net.hasor.rsf.hprose.io.unserialize.CharsArrayUnserializer;
import net.hasor.rsf.hprose.io.unserialize.DateArrayUnserializer;
import net.hasor.rsf.hprose.io.unserialize.DateTimeArrayUnserializer;
import net.hasor.rsf.hprose.io.unserialize.DateTimeUnserializer;
import net.hasor.rsf.hprose.io.unserialize.DateUnserializer;
import net.hasor.rsf.hprose.io.unserialize.DefaultUnserializer;
import net.hasor.rsf.hprose.io.unserialize.DoubleArrayUnserializer;
import net.hasor.rsf.hprose.io.unserialize.DoubleObjectUnserializer;
import net.hasor.rsf.hprose.io.unserialize.DoubleUnserializer;
import net.hasor.rsf.hprose.io.unserialize.EnumUnserializer;
import net.hasor.rsf.hprose.io.unserialize.FakeReaderRefer;
import net.hasor.rsf.hprose.io.unserialize.FloatArrayUnserializer;
import net.hasor.rsf.hprose.io.unserialize.FloatObjectUnserializer;
import net.hasor.rsf.hprose.io.unserialize.FloatUnserializer;
import net.hasor.rsf.hprose.io.unserialize.IntArrayUnserializer;
import net.hasor.rsf.hprose.io.unserialize.IntObjectUnserializer;
import net.hasor.rsf.hprose.io.unserialize.IntUnserializer;
import net.hasor.rsf.hprose.io.unserialize.LongArrayUnserializer;
import net.hasor.rsf.hprose.io.unserialize.LongObjectUnserializer;
import net.hasor.rsf.hprose.io.unserialize.LongUnserializer;
import net.hasor.rsf.hprose.io.unserialize.ObjectArrayUnserializer;
import net.hasor.rsf.hprose.io.unserialize.RawReader;
import net.hasor.rsf.hprose.io.unserialize.ReaderRefer;
import net.hasor.rsf.hprose.io.unserialize.RealReaderRefer;
import net.hasor.rsf.hprose.io.unserialize.ReferenceReader;
import net.hasor.rsf.hprose.io.unserialize.ShortArrayUnserializer;
import net.hasor.rsf.hprose.io.unserialize.ShortObjectUnserializer;
import net.hasor.rsf.hprose.io.unserialize.ShortUnserializer;
import net.hasor.rsf.hprose.io.unserialize.StringArrayUnserializer;
import net.hasor.rsf.hprose.io.unserialize.StringBufferArrayUnserializer;
import net.hasor.rsf.hprose.io.unserialize.StringBufferUnserializer;
import net.hasor.rsf.hprose.io.unserialize.StringBuilderArrayUnserializer;
import net.hasor.rsf.hprose.io.unserialize.StringBuilderUnserializer;
import net.hasor.rsf.hprose.io.unserialize.StringUnserializer;
import net.hasor.rsf.hprose.io.unserialize.TimeArrayUnserializer;
import net.hasor.rsf.hprose.io.unserialize.TimeUnserializer;
import net.hasor.rsf.hprose.io.unserialize.TimestampArrayUnserializer;
import net.hasor.rsf.hprose.io.unserialize.TimestampUnserializer;
import net.hasor.rsf.hprose.io.unserialize.UUIDArrayUnserializer;
import net.hasor.rsf.hprose.io.unserialize.UUIDUnserializer;
import net.hasor.rsf.hprose.io.unserialize.UnserializerFactory;
import net.hasor.rsf.hprose.io.unserialize.ValueReader;
import net.hasor.rsf.hprose.util.ClassUtil;

public class Reader {
    public final InputStream stream;
    final HproseMode mode;
    final ArrayList<Object> classref = new ArrayList();
    final IdentityHashMap<Object, String[]> membersref = new IdentityHashMap();
    final ReaderRefer refer;

    public Reader(InputStream stream) {
        this(stream, HproseMode.MemberMode, false);
    }

    public Reader(InputStream stream, boolean simple) {
        this(stream, HproseMode.MemberMode, simple);
    }

    public Reader(InputStream stream, HproseMode mode) {
        this(stream, mode, false);
    }

    public Reader(InputStream stream, HproseMode mode, boolean simple) {
        this.stream = stream;
        this.mode = mode;
        this.refer = simple ? new FakeReaderRefer() : new RealReaderRefer();
    }

    public Reader(ByteBuffer buffer) {
        this(buffer, HproseMode.MemberMode, false);
    }

    public Reader(ByteBuffer buffer, boolean simple) {
        this(buffer, HproseMode.MemberMode, simple);
    }

    public Reader(ByteBuffer buffer, HproseMode mode) {
        this(buffer, mode, false);
    }

    public Reader(ByteBuffer buffer, HproseMode mode, boolean simple) {
        this(new ByteBufferStream(buffer).getInputStream(), mode, simple);
    }

    public Reader(byte[] bytes) {
        this(bytes, HproseMode.MemberMode, false);
    }

    public Reader(byte[] bytes, boolean simple) {
        this(bytes, HproseMode.MemberMode, simple);
    }

    public Reader(byte[] bytes, HproseMode mode) {
        this(bytes, mode, false);
    }

    public Reader(byte[] bytes, HproseMode mode, boolean simple) {
        this(new ByteArrayInputStream(bytes), mode, simple);
    }

    public final HproseException unexpectedTag(int tag) {
        return this.unexpectedTag(tag, null);
    }

    public final HproseException unexpectedTag(int tag, String expectTags) {
        if (tag == -1) {
            return new HproseException("No byte found in stream");
        }
        if (expectTags == null) {
            return new HproseException("Unexpected serialize tag '" + (char)tag + "' in stream");
        }
        return new HproseException("Tag '" + expectTags + "' expected, but '" + (char)tag + "' found in stream");
    }

    public final void checkTag(int tag, int expectTag) throws HproseException {
        if (tag != expectTag) {
            throw this.unexpectedTag(tag, new String(new char[]{(char)expectTag}));
        }
    }

    public final void checkTag(int expectTag) throws IOException {
        this.checkTag(this.stream.read(), expectTag);
    }

    public final int checkTags(int tag, String expectTags) throws IOException {
        if (expectTags.indexOf(tag) == -1) {
            throw this.unexpectedTag(tag, expectTags);
        }
        return tag;
    }

    public final int checkTags(String expectTags) throws IOException {
        return this.checkTags(this.stream.read(), expectTags);
    }

    public final void skip(int tag) throws IOException {
        int c = this.stream.read();
        assert (c == tag) : "Tag '" + (char)tag + "' expected, but '" + (char)c + "' found in stream";
    }

    public final byte readByte(int tag) throws IOException {
        return (byte)ValueReader.readInt(this, tag);
    }

    public final short readShort(int tag) throws IOException {
        return (short)ValueReader.readInt(this, tag);
    }

    public final int readInt(int tag) throws IOException {
        return ValueReader.readInt(this, tag);
    }

    public final long readLong(int tag) throws IOException {
        return ValueReader.readLong(this, tag);
    }

    public final int readIntWithoutTag() throws IOException {
        return ValueReader.readInt(this);
    }

    public final BigInteger readBigIntegerWithoutTag() throws IOException {
        return ValueReader.readBigInteger(this);
    }

    public final long readLongWithoutTag() throws IOException {
        return ValueReader.readInt(this);
    }

    public final double readDoubleWithoutTag() throws IOException {
        return ValueReader.readDouble(this);
    }

    public final double readInfinityWithoutTag() throws IOException {
        return ValueReader.readInfinity(this);
    }

    public final Calendar readDateWithoutTag() throws IOException {
        return ReferenceReader.readDateTime(this).toCalendar();
    }

    public final Calendar readTimeWithoutTag() throws IOException {
        return ReferenceReader.readTime(this).toCalendar();
    }

    public final byte[] readBytesWithoutTag() throws IOException {
        return ReferenceReader.readBytes(this);
    }

    public final String readUTF8CharWithoutTag() throws IOException {
        return ValueReader.readUTF8Char(this);
    }

    public final String readStringWithoutTag() throws IOException {
        return ReferenceReader.readString(this);
    }

    public final char[] readCharsWithoutTag() throws IOException {
        return ReferenceReader.readChars(this);
    }

    public final UUID readUUIDWithoutTag() throws IOException {
        return ReferenceReader.readUUID(this);
    }

    public final ArrayList readListWithoutTag() throws IOException {
        return ReferenceReader.readArrayList(this);
    }

    public final HashMap readMapWithoutTag() throws IOException {
        return ReferenceReader.readHashMap(this);
    }

    public final Object readObjectWithoutTag(Type type) throws IOException {
        return ReferenceReader.readObject(this, type);
    }

    public final Object unserialize() throws IOException {
        return DefaultUnserializer.instance.read(this);
    }

    public final boolean readBoolean() throws IOException {
        return BooleanUnserializer.instance.read(this);
    }

    public final Boolean readBooleanObject() throws IOException {
        return BooleanObjectUnserializer.instance.read(this);
    }

    public final char readChar() throws IOException {
        return CharUnserializer.instance.read(this).charValue();
    }

    public final Character readCharObject() throws IOException {
        return CharObjectUnserializer.instance.read(this);
    }

    public final byte readByte() throws IOException {
        return ByteUnserializer.instance.read(this);
    }

    public final Byte readByteObject() throws IOException {
        return ByteObjectUnserializer.instance.read(this);
    }

    public final short readShort() throws IOException {
        return ShortUnserializer.instance.read(this);
    }

    public final Short readShortObject() throws IOException {
        return ShortObjectUnserializer.instance.read(this);
    }

    public final int readInt() throws IOException {
        return IntUnserializer.instance.read(this);
    }

    public final Integer readIntObject() throws IOException {
        return IntObjectUnserializer.instance.read(this);
    }

    public final long readLong() throws IOException {
        return LongUnserializer.instance.read(this);
    }

    public final Long readLongObject() throws IOException {
        return LongObjectUnserializer.instance.read(this);
    }

    public final float readFloat() throws IOException {
        return FloatUnserializer.instance.read(this).floatValue();
    }

    public final Float readFloatObject() throws IOException {
        return FloatObjectUnserializer.instance.read(this);
    }

    public final double readDouble() throws IOException {
        return DoubleUnserializer.instance.read(this);
    }

    public final Double readDoubleObject() throws IOException {
        return DoubleObjectUnserializer.instance.read(this);
    }

    public final <T extends Enum<T>> T readEnum(Class<T> type) throws IOException {
        return (T)((Enum)EnumUnserializer.instance.read(this, type));
    }

    public final String readString() throws IOException {
        return StringUnserializer.instance.read(this);
    }

    public final BigInteger readBigInteger() throws IOException {
        return BigIntegerUnserializer.instance.read(this);
    }

    public final java.sql.Date readDate() throws IOException {
        return DateUnserializer.instance.read(this);
    }

    public final Time readTime() throws IOException {
        return TimeUnserializer.instance.read(this);
    }

    public final Date readDateTime() throws IOException {
        return DateTimeUnserializer.instance.read(this);
    }

    public final Timestamp readTimestamp() throws IOException {
        return TimestampUnserializer.instance.read(this);
    }

    public final Calendar readCalendar() throws IOException {
        return CalendarUnserializer.instance.read(this);
    }

    public final BigDecimal readBigDecimal() throws IOException {
        return BigDecimalUnserializer.instance.read(this);
    }

    public final StringBuilder readStringBuilder() throws IOException {
        return StringBuilderUnserializer.instance.read(this);
    }

    public final StringBuffer readStringBuffer() throws IOException {
        return StringBufferUnserializer.instance.read(this);
    }

    public final UUID readUUID() throws IOException {
        return UUIDUnserializer.instance.read(this);
    }

    public final void readArray(Type[] types, Object[] a, int count) throws IOException {
        ReferenceReader.readArray(this, types, a, count);
    }

    public final Object[] readArray(int count) throws IOException {
        return ReferenceReader.readArray(this, count);
    }

    public final Object[] readObjectArray() throws IOException {
        return ObjectArrayUnserializer.instance.read(this);
    }

    public final boolean[] readBooleanArray() throws IOException {
        return BooleanArrayUnserializer.instance.read(this);
    }

    public final char[] readCharArray() throws IOException {
        return CharArrayUnserializer.instance.read(this);
    }

    public final byte[] readByteArray() throws IOException {
        return ByteArrayUnserializer.instance.read(this);
    }

    public final short[] readShortArray() throws IOException {
        return ShortArrayUnserializer.instance.read(this);
    }

    public final int[] readIntArray() throws IOException {
        return IntArrayUnserializer.instance.read(this);
    }

    public final long[] readLongArray() throws IOException {
        return LongArrayUnserializer.instance.read(this);
    }

    public final float[] readFloatArray() throws IOException {
        return FloatArrayUnserializer.instance.read(this);
    }

    public final double[] readDoubleArray() throws IOException {
        return DoubleArrayUnserializer.instance.read(this);
    }

    public final String[] readStringArray() throws IOException {
        return StringArrayUnserializer.instance.read(this);
    }

    public final BigInteger[] readBigIntegerArray() throws IOException {
        return BigIntegerArrayUnserializer.instance.read(this);
    }

    public final java.sql.Date[] readDateArray() throws IOException {
        return DateArrayUnserializer.instance.read(this);
    }

    public final Time[] readTimeArray() throws IOException {
        return TimeArrayUnserializer.instance.read(this);
    }

    public final Timestamp[] readTimestampArray() throws IOException {
        return TimestampArrayUnserializer.instance.read(this);
    }

    public final Date[] readDateTimeArray() throws IOException {
        return DateTimeArrayUnserializer.instance.read(this);
    }

    public final Calendar[] readCalendarArray() throws IOException {
        return CalendarArrayUnserializer.instance.read(this);
    }

    public final BigDecimal[] readBigDecimalArray() throws IOException {
        return BigDecimalArrayUnserializer.instance.read(this);
    }

    public final StringBuilder[] readStringBuilderArray() throws IOException {
        return StringBuilderArrayUnserializer.instance.read(this);
    }

    public final StringBuffer[] readStringBufferArray() throws IOException {
        return StringBufferArrayUnserializer.instance.read(this);
    }

    public final UUID[] readUUIDArray() throws IOException {
        return UUIDArrayUnserializer.instance.read(this);
    }

    public final char[][] readCharsArray() throws IOException {
        return CharsArrayUnserializer.instance.read(this);
    }

    public final byte[][] readBytesArray() throws IOException {
        return BytesArrayUnserializer.instance.read(this);
    }

    public final Object unserialize(Type type) throws IOException {
        if (type == null) {
            return DefaultUnserializer.instance.read(this);
        }
        Class<?> cls = ClassUtil.toClass(type);
        return UnserializerFactory.get(cls).read(this, this.stream.read(), type);
    }

    public final <T> T unserialize(Class<T> type) throws IOException {
        return (T)this.unserialize((Type)type);
    }

    public final Object readRef() throws IOException {
        return this.refer.read(ValueReader.readInt(this));
    }

    public final <T> T readRef(Type type) throws IOException {
        return (T)DefaultConverter.instance.convertTo(this.readRef(), type);
    }

    public void setRef(Object obj) {
        this.refer.set(obj);
    }

    public void readClass() throws IOException {
        String className = ValueReader.readString(this);
        int count = ValueReader.readCount(this);
        String[] memberNames = new String[count];
        StringUnserializer unserialize = StringUnserializer.instance;
        for (int i = 0; i < count; ++i) {
            memberNames[i] = (String)unserialize.read(this, this.stream.read(), (Type)((Object)String.class));
        }
        this.stream.read();
        Class cls = HproseClassManager.getClass(className);
        Class key = cls == null || Void.TYPE.equals(cls) ? new Class() : cls;
        this.classref.add(key);
        this.membersref.put(key, memberNames);
    }

    public Object readClassRef() throws IOException {
        return this.classref.get(ValueReader.readInt(this, 123));
    }

    public String[] getMemberNames(Object cr) {
        return this.membersref.get(cr);
    }

    public String[] readMemberNames() throws IOException {
        return this.getMemberNames(this.readClassRef());
    }

    public final String tagToString(int tag) throws IOException {
        switch (tag) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 105: {
                return "Integer";
            }
            case 108: {
                return "BigInteger";
            }
            case 100: {
                return "Double";
            }
            case 110: {
                return "Null";
            }
            case 101: {
                return "Empty String";
            }
            case 116: {
                return "Boolean True";
            }
            case 102: {
                return "Boolean False";
            }
            case 78: {
                return "NaN";
            }
            case 73: {
                return "Infinity";
            }
            case 68: {
                return "DateTime";
            }
            case 84: {
                return "DateTime";
            }
            case 98: {
                return "Byte[]";
            }
            case 117: {
                return "Char";
            }
            case 115: {
                return "String";
            }
            case 103: {
                return "Guid";
            }
            case 97: {
                return "IList";
            }
            case 109: {
                return "IDictionary";
            }
            case 99: {
                return "Class";
            }
            case 111: {
                return "Object";
            }
            case 114: {
                return "Object Reference";
            }
            case 69: {
                throw new HproseException(this.readString());
            }
        }
        throw this.unexpectedTag(tag);
    }

    public final ByteBufferStream readRaw() throws IOException {
        ByteBufferStream rawstream = new ByteBufferStream();
        this.readRaw(rawstream.getOutputStream());
        rawstream.flip();
        return rawstream;
    }

    public final void readRaw(OutputStream ostream) throws IOException {
        RawReader.readRaw(this.stream, ostream, this.stream.read());
    }

    public final void reset() {
        this.refer.reset();
        this.classref.clear();
        this.membersref.clear();
    }
}

