/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.io.unserialize;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import net.hasor.rsf.hprose.common.HproseException;
import net.hasor.rsf.hprose.io.access.Accessors;
import net.hasor.rsf.hprose.io.access.ConstructorAccessor;
import net.hasor.rsf.hprose.io.access.MemberAccessor;
import net.hasor.rsf.hprose.io.convert.Converter;
import net.hasor.rsf.hprose.io.convert.ConverterFactory;
import net.hasor.rsf.hprose.io.unserialize.BigDecimalUnserializer;
import net.hasor.rsf.hprose.io.unserialize.BigIntegerUnserializer;
import net.hasor.rsf.hprose.io.unserialize.BooleanUnserializer;
import net.hasor.rsf.hprose.io.unserialize.ByteArrayUnserializer;
import net.hasor.rsf.hprose.io.unserialize.ByteUnserializer;
import net.hasor.rsf.hprose.io.unserialize.CalendarUnserializer;
import net.hasor.rsf.hprose.io.unserialize.CharArrayUnserializer;
import net.hasor.rsf.hprose.io.unserialize.CharUnserializer;
import net.hasor.rsf.hprose.io.unserialize.DateTimeUnserializer;
import net.hasor.rsf.hprose.io.unserialize.DateUnserializer;
import net.hasor.rsf.hprose.io.unserialize.DoubleUnserializer;
import net.hasor.rsf.hprose.io.unserialize.FloatUnserializer;
import net.hasor.rsf.hprose.io.unserialize.IntUnserializer;
import net.hasor.rsf.hprose.io.unserialize.LongUnserializer;
import net.hasor.rsf.hprose.io.unserialize.Reader;
import net.hasor.rsf.hprose.io.unserialize.ShortUnserializer;
import net.hasor.rsf.hprose.io.unserialize.StringBufferUnserializer;
import net.hasor.rsf.hprose.io.unserialize.StringBuilderUnserializer;
import net.hasor.rsf.hprose.io.unserialize.StringUnserializer;
import net.hasor.rsf.hprose.io.unserialize.TimeUnserializer;
import net.hasor.rsf.hprose.io.unserialize.TimestampUnserializer;
import net.hasor.rsf.hprose.io.unserialize.UUIDUnserializer;
import net.hasor.rsf.hprose.io.unserialize.Unserializer;
import net.hasor.rsf.hprose.io.unserialize.UnserializerFactory;
import net.hasor.rsf.hprose.io.unserialize.ValueReader;
import net.hasor.rsf.hprose.util.CaseInsensitiveMap;
import net.hasor.rsf.hprose.util.ClassUtil;
import net.hasor.rsf.hprose.util.DateTime;
import net.hasor.rsf.hprose.util.LinkedCaseInsensitiveMap;

public final class ReferenceReader {
    public static final DateTime readDateTime(Reader reader) throws IOException {
        DateTime datetime = ValueReader.readDateTime(reader);
        reader.setRef(datetime);
        return datetime;
    }

    public static final DateTime readTime(Reader reader) throws IOException {
        DateTime datetime = ValueReader.readTime(reader);
        reader.setRef(datetime);
        return datetime;
    }

    public static final UUID readUUID(Reader reader) throws IOException {
        UUID uuid = ValueReader.readUUID(reader);
        reader.setRef(uuid);
        return uuid;
    }

    public static final String readString(Reader reader) throws IOException {
        String str = ValueReader.readString(reader);
        reader.setRef(str);
        return str;
    }

    public static final char[] readChars(Reader reader) throws IOException {
        char[] chars = ValueReader.readChars(reader);
        reader.setRef(chars);
        return chars;
    }

    public static final char[] readCharArray(Reader reader) throws IOException {
        int count = ValueReader.readCount(reader);
        char[] a = new char[count];
        reader.setRef(a);
        CharUnserializer unserializer = CharUnserializer.instance;
        for (int i = 0; i < count; ++i) {
            a[i] = unserializer.read(reader).charValue();
        }
        reader.skip(125);
        return a;
    }

    public static final char[][] readCharsArray(Reader reader) throws IOException {
        int count = ValueReader.readCount(reader);
        char[][] a = new char[count][];
        reader.setRef(a);
        CharArrayUnserializer unserializer = CharArrayUnserializer.instance;
        for (int i = 0; i < count; ++i) {
            a[i] = unserializer.read(reader);
        }
        reader.skip(125);
        return a;
    }

    public static final byte[] readBytes(Reader reader) throws IOException {
        byte[] bytes = ValueReader.readBytes(reader);
        reader.setRef(bytes);
        return bytes;
    }

    public static final byte[] readByteArray(Reader reader) throws IOException {
        int count = ValueReader.readCount(reader);
        byte[] a = new byte[count];
        reader.setRef(a);
        ByteUnserializer unserializer = ByteUnserializer.instance;
        for (int i = 0; i < count; ++i) {
            a[i] = unserializer.read(reader);
        }
        reader.skip(125);
        return a;
    }

    public static final byte[][] readBytesArray(Reader reader) throws IOException {
        int count = ValueReader.readCount(reader);
        byte[][] a = new byte[count][];
        reader.setRef(a);
        ByteArrayUnserializer unserializer = ByteArrayUnserializer.instance;
        for (int i = 0; i < count; ++i) {
            a[i] = unserializer.read(reader);
        }
        reader.skip(125);
        return a;
    }

    public static final short[] readShortArray(Reader reader) throws IOException {
        int count = ValueReader.readCount(reader);
        short[] a = new short[count];
        reader.setRef(a);
        ShortUnserializer unserializer = ShortUnserializer.instance;
        for (int i = 0; i < count; ++i) {
            a[i] = unserializer.read(reader);
        }
        reader.skip(125);
        return a;
    }

    public static final int[] readIntArray(Reader reader) throws IOException {
        int count = ValueReader.readCount(reader);
        int[] a = new int[count];
        reader.setRef(a);
        IntUnserializer unserializer = IntUnserializer.instance;
        for (int i = 0; i < count; ++i) {
            a[i] = unserializer.read(reader);
        }
        reader.skip(125);
        return a;
    }

    public static final long[] readLongArray(Reader reader) throws IOException {
        int count = ValueReader.readCount(reader);
        long[] a = new long[count];
        reader.setRef(a);
        LongUnserializer unserializer = LongUnserializer.instance;
        for (int i = 0; i < count; ++i) {
            a[i] = unserializer.read(reader);
        }
        reader.skip(125);
        return a;
    }

    public static final boolean[] readBooleanArray(Reader reader) throws IOException {
        int count = ValueReader.readCount(reader);
        boolean[] a = new boolean[count];
        reader.setRef(a);
        BooleanUnserializer unserializer = BooleanUnserializer.instance;
        for (int i = 0; i < count; ++i) {
            a[i] = unserializer.read(reader);
        }
        reader.skip(125);
        return a;
    }

    public static final float[] readFloatArray(Reader reader) throws IOException {
        int count = ValueReader.readCount(reader);
        float[] a = new float[count];
        reader.setRef(a);
        FloatUnserializer unserializer = FloatUnserializer.instance;
        for (int i = 0; i < count; ++i) {
            a[i] = unserializer.read(reader).floatValue();
        }
        reader.skip(125);
        return a;
    }

    public static final double[] readDoubleArray(Reader reader) throws IOException {
        int count = ValueReader.readCount(reader);
        double[] a = new double[count];
        reader.setRef(a);
        DoubleUnserializer unserializer = DoubleUnserializer.instance;
        for (int i = 0; i < count; ++i) {
            a[i] = unserializer.read(reader);
        }
        reader.skip(125);
        return a;
    }

    public static final BigDecimal[] readBigDecimalArray(Reader reader) throws IOException {
        int count = ValueReader.readCount(reader);
        BigDecimal[] a = new BigDecimal[count];
        reader.setRef(a);
        BigDecimalUnserializer unserializer = BigDecimalUnserializer.instance;
        for (int i = 0; i < count; ++i) {
            a[i] = unserializer.read(reader);
        }
        reader.skip(125);
        return a;
    }

    public static final BigInteger[] readBigIntegerArray(Reader reader) throws IOException {
        int count = ValueReader.readCount(reader);
        BigInteger[] a = new BigInteger[count];
        reader.setRef(a);
        BigIntegerUnserializer unserializer = BigIntegerUnserializer.instance;
        for (int i = 0; i < count; ++i) {
            a[i] = unserializer.read(reader);
        }
        reader.skip(125);
        return a;
    }

    public static final String[] readStringArray(Reader reader) throws IOException {
        int count = ValueReader.readCount(reader);
        String[] a = new String[count];
        reader.setRef(a);
        StringUnserializer unserializer = StringUnserializer.instance;
        for (int i = 0; i < count; ++i) {
            a[i] = unserializer.read(reader);
        }
        reader.skip(125);
        return a;
    }

    public static final StringBuilder[] readStringBuilderArray(Reader reader) throws IOException {
        int count = ValueReader.readCount(reader);
        StringBuilder[] a = new StringBuilder[count];
        reader.setRef(a);
        StringBuilderUnserializer unserializer = StringBuilderUnserializer.instance;
        for (int i = 0; i < count; ++i) {
            a[i] = unserializer.read(reader);
        }
        reader.skip(125);
        return a;
    }

    public static final StringBuffer[] readStringBufferArray(Reader reader) throws IOException {
        int count = ValueReader.readCount(reader);
        StringBuffer[] a = new StringBuffer[count];
        reader.setRef(a);
        StringBufferUnserializer unserializer = StringBufferUnserializer.instance;
        for (int i = 0; i < count; ++i) {
            a[i] = unserializer.read(reader);
        }
        reader.skip(125);
        return a;
    }

    public static final Calendar[] readCalendarArray(Reader reader) throws IOException {
        int count = ValueReader.readCount(reader);
        Calendar[] a = new Calendar[count];
        reader.setRef(a);
        CalendarUnserializer unserializer = CalendarUnserializer.instance;
        for (int i = 0; i < count; ++i) {
            a[i] = unserializer.read(reader);
        }
        reader.skip(125);
        return a;
    }

    public static final Date[] readDateArray(Reader reader) throws IOException {
        int count = ValueReader.readCount(reader);
        Date[] a = new Date[count];
        reader.setRef(a);
        DateUnserializer unserializer = DateUnserializer.instance;
        for (int i = 0; i < count; ++i) {
            a[i] = unserializer.read(reader);
        }
        reader.skip(125);
        return a;
    }

    public static final Time[] readTimeArray(Reader reader) throws IOException {
        int count = ValueReader.readCount(reader);
        Time[] a = new Time[count];
        reader.setRef(a);
        TimeUnserializer unserializer = TimeUnserializer.instance;
        for (int i = 0; i < count; ++i) {
            a[i] = unserializer.read(reader);
        }
        reader.skip(125);
        return a;
    }

    public static final java.util.Date[] readDateTimeArray(Reader reader) throws IOException {
        int count = ValueReader.readCount(reader);
        java.util.Date[] a = new java.util.Date[count];
        reader.setRef(a);
        DateTimeUnserializer unserializer = DateTimeUnserializer.instance;
        for (int i = 0; i < count; ++i) {
            a[i] = unserializer.read(reader);
        }
        reader.skip(125);
        return a;
    }

    public static final Timestamp[] readTimestampArray(Reader reader) throws IOException {
        int count = ValueReader.readCount(reader);
        Timestamp[] a = new Timestamp[count];
        reader.setRef(a);
        TimestampUnserializer unserializer = TimestampUnserializer.instance;
        for (int i = 0; i < count; ++i) {
            a[i] = unserializer.read(reader);
        }
        reader.skip(125);
        return a;
    }

    public static final UUID[] readUUIDArray(Reader reader) throws IOException {
        int count = ValueReader.readCount(reader);
        UUID[] a = new UUID[count];
        reader.setRef(a);
        UUIDUnserializer unserializer = UUIDUnserializer.instance;
        for (int i = 0; i < count; ++i) {
            a[i] = unserializer.read(reader);
        }
        reader.skip(125);
        return a;
    }

    public static final <T> T[] readArray(Reader reader, Type type) throws IOException {
        int count = ValueReader.readCount(reader);
        Type componentType = ClassUtil.getComponentType(type);
        Class<?> compontentClass = ClassUtil.toClass(componentType);
        Object[] a = (Object[])Array.newInstance(compontentClass, count);
        reader.setRef(a);
        if (count > 0) {
            InputStream stream = reader.stream;
            Unserializer unserializer = UnserializerFactory.get(compontentClass);
            for (int i = 0; i < count; ++i) {
                a[i] = unserializer.read(reader, stream.read(), componentType);
            }
        }
        reader.skip(125);
        return a;
    }

    public static final Object[] readArray(Reader reader, int count) throws IOException {
        Object[] a = new Object[count];
        reader.setRef(a);
        for (int i = 0; i < count; ++i) {
            a[i] = reader.unserialize();
        }
        reader.skip(125);
        return a;
    }

    public static final Object[] readArray(Reader reader) throws IOException {
        int count = ValueReader.readCount(reader);
        return ReferenceReader.readArray(reader, count);
    }

    public static final void readArray(Reader reader, Type[] types, Object[] a, int count) throws IOException {
        reader.setRef(a);
        for (int i = 0; i < count; ++i) {
            a[i] = reader.unserialize(types[i]);
        }
        reader.skip(125);
    }

    public static final ArrayList readArrayList(Reader reader) throws IOException {
        int count = ValueReader.readCount(reader);
        ArrayList<Object> a = new ArrayList<Object>(count);
        reader.setRef(a);
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                a.add(reader.unserialize());
            }
        }
        reader.skip(125);
        return a;
    }

    public static final Collection readCollection(Reader reader, Class<? extends Collection> type, Type componentType) throws IOException {
        int count = ValueReader.readCount(reader);
        Collection a = ConstructorAccessor.newInstance(type);
        reader.setRef(a);
        if (count > 0) {
            InputStream stream = reader.stream;
            Class<?> compontentClass = ClassUtil.toClass(componentType);
            Unserializer unserializer = UnserializerFactory.get(compontentClass);
            for (int i = 0; i < count; ++i) {
                a.add(unserializer.read(reader, stream.read(), componentType));
            }
        }
        reader.skip(125);
        return a;
    }

    public static void readCollection(Reader reader, Type type, Collection a, int count) throws IOException {
        reader.setRef(a);
        if (count > 0) {
            InputStream stream = reader.stream;
            Type componentType = ClassUtil.getComponentType(type);
            Class<?> compontentClass = ClassUtil.toClass(componentType);
            Unserializer unserializer = UnserializerFactory.get(compontentClass);
            for (int i = 0; i < count; ++i) {
                a.add(unserializer.read(reader, stream.read(), componentType));
            }
        }
        reader.skip(125);
    }

    public static final ArrayList readArrayList(Reader reader, Type type) throws IOException {
        int count = ValueReader.readCount(reader);
        ArrayList a = new ArrayList(count);
        ReferenceReader.readCollection(reader, type, a, count);
        return a;
    }

    public static final LinkedList readLinkedList(Reader reader, Type type) throws IOException {
        int count = ValueReader.readCount(reader);
        LinkedList a = new LinkedList();
        ReferenceReader.readCollection(reader, type, a, count);
        return a;
    }

    public static final HashSet readHashSet(Reader reader, Type type) throws IOException {
        int count = ValueReader.readCount(reader);
        HashSet a = new HashSet(count);
        ReferenceReader.readCollection(reader, type, a, count);
        return a;
    }

    public static final TreeSet readTreeSet(Reader reader, Type type) throws IOException {
        int count = ValueReader.readCount(reader);
        TreeSet a = new TreeSet();
        ReferenceReader.readCollection(reader, type, a, count);
        return a;
    }

    public static final Collection readCollection(Reader reader, Type type) throws IOException {
        int count = ValueReader.readCount(reader);
        Class<?> cls = ClassUtil.toClass(type);
        Collection a = (Collection)ConstructorAccessor.newInstance(cls);
        ReferenceReader.readCollection(reader, type, a, count);
        return a;
    }

    public static final HashMap readHashMap(Reader reader) throws IOException {
        int count = ValueReader.readCount(reader);
        HashMap<Object, Object> m = new HashMap<Object, Object>(count);
        reader.setRef(m);
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                Object key = reader.unserialize();
                Object value = reader.unserialize();
                m.put(key, value);
            }
        }
        reader.skip(125);
        return m;
    }

    public static void readListAsMap(Reader reader, Map m, Type keyType, Type valueType, int count) throws IOException {
        reader.setRef(m);
        if (count > 0) {
            InputStream stream = reader.stream;
            Class<?> keyClass = ClassUtil.toClass(keyType);
            Class<?> valueClass = ClassUtil.toClass(valueType);
            Converter converter = ConverterFactory.get(keyClass);
            Unserializer unserializer = UnserializerFactory.get(valueClass);
            for (int i = 0; i < count; ++i) {
                m.put(converter.convertTo(i, keyType), unserializer.read(reader, stream.read(), valueType));
            }
        }
        reader.skip(125);
    }

    public static void readListAsMap(Reader reader, Type type, Map m, int count) throws IOException {
        ReferenceReader.readListAsMap(reader, m, ClassUtil.getKeyType(type), ClassUtil.getValueType(type), count);
    }

    public static Map readListAsMap(Reader reader, Class<? extends Map> type, Type keyType, Type valueType) throws IOException {
        int count = ValueReader.readCount(reader);
        Map m = ConstructorAccessor.newInstance(type);
        ReferenceReader.readListAsMap(reader, m, keyType, valueType, count);
        return m;
    }

    public static final HashMap readListAsHashMap(Reader reader, Type type) throws IOException {
        int count = ValueReader.readCount(reader);
        HashMap m = new HashMap(count);
        ReferenceReader.readListAsMap(reader, type, m, count);
        return m;
    }

    public static final LinkedHashMap readListAsLinkedHashMap(Reader reader, Type type) throws IOException {
        int count = ValueReader.readCount(reader);
        LinkedHashMap m = new LinkedHashMap(count);
        ReferenceReader.readListAsMap(reader, type, m, count);
        return m;
    }

    public static final LinkedCaseInsensitiveMap readListAsLinkedCaseInsensitiveMap(Reader reader, Type type) throws IOException {
        int count = ValueReader.readCount(reader);
        LinkedCaseInsensitiveMap m = new LinkedCaseInsensitiveMap(count);
        ReferenceReader.readListAsMap(reader, type, m, count);
        return m;
    }

    public static final CaseInsensitiveMap readListAsCaseInsensitiveMap(Reader reader, Type type) throws IOException {
        int count = ValueReader.readCount(reader);
        CaseInsensitiveMap m = new CaseInsensitiveMap(count);
        ReferenceReader.readListAsMap(reader, type, m, count);
        return m;
    }

    public static final TreeMap readListAsTreeMap(Reader reader, Type type) throws IOException {
        int count = ValueReader.readCount(reader);
        TreeMap m = new TreeMap();
        ReferenceReader.readListAsMap(reader, type, m, count);
        return m;
    }

    public static final Map readListAsMap(Reader reader, Type type) throws IOException {
        int count = ValueReader.readCount(reader);
        Class<?> cls = ClassUtil.toClass(type);
        Map m = (Map)ConstructorAccessor.newInstance(cls);
        ReferenceReader.readListAsMap(reader, type, m, count);
        return m;
    }

    public static void readObjectAsMap(Reader reader, Map<String, Object> m, Map<String, Type> typeMap, String[] memberNames, int count) throws IOException {
        reader.setRef(m);
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                String key = memberNames[i];
                if (typeMap.containsKey(key)) {
                    Type valueType = typeMap.get(key);
                    m.put(key, reader.unserialize(valueType));
                    continue;
                }
                m.put(key, reader.unserialize());
            }
        }
        reader.skip(125);
    }

    public static final Map<String, Object> readObjectAsMap(Reader reader, Class<? extends Map> type, Map<String, Type> typeMap) throws IOException {
        String[] memberNames = reader.readMemberNames();
        int count = memberNames.length;
        Map m = ConstructorAccessor.newInstance(type);
        ReferenceReader.readObjectAsMap(reader, m, typeMap, memberNames, count);
        return m;
    }

    public static void readObjectAsMap(Reader reader, Map m, Type keyType, Type valueType, int count, String[] memberNames) throws IOException {
        reader.setRef(m);
        if (count > 0) {
            InputStream stream = reader.stream;
            Class<?> keyClass = ClassUtil.toClass(keyType);
            Class<?> valueClass = ClassUtil.toClass(valueType);
            Converter converter = ConverterFactory.get(keyClass);
            Unserializer unserializer = UnserializerFactory.get(valueClass);
            for (int i = 0; i < count; ++i) {
                m.put(converter.convertTo(memberNames[i], keyType), unserializer.read(reader, stream.read(), valueType));
            }
        }
        reader.skip(125);
    }

    public static final Map readObjectAsMap(Reader reader, Class<? extends Map> type, Type keyType, Type valueType) throws IOException {
        String[] memberNames = reader.readMemberNames();
        int count = memberNames.length;
        Map m = ConstructorAccessor.newInstance(type);
        ReferenceReader.readObjectAsMap(reader, m, keyType, valueType, count, memberNames);
        return m;
    }

    public static void readObjectAsMap(Reader reader, Type type, Map m, int count, String[] memberNames) throws IOException {
        ReferenceReader.readObjectAsMap(reader, m, ClassUtil.getKeyType(type), ClassUtil.getValueType(type), count, memberNames);
    }

    public static final HashMap readObjectAsHashMap(Reader reader, Type type) throws IOException {
        String[] memberNames = reader.readMemberNames();
        int count = memberNames.length;
        HashMap m = new HashMap(count);
        ReferenceReader.readObjectAsMap(reader, type, m, count, memberNames);
        return m;
    }

    public static final LinkedHashMap readObjectAsLinkedHashMap(Reader reader, Type type) throws IOException {
        String[] memberNames = reader.readMemberNames();
        int count = memberNames.length;
        LinkedHashMap m = new LinkedHashMap(count);
        ReferenceReader.readObjectAsMap(reader, type, m, count, memberNames);
        return m;
    }

    public static final LinkedCaseInsensitiveMap readObjectAsLinkedCaseInsensitiveMap(Reader reader, Type type) throws IOException {
        String[] memberNames = reader.readMemberNames();
        int count = memberNames.length;
        LinkedCaseInsensitiveMap m = new LinkedCaseInsensitiveMap(count);
        ReferenceReader.readObjectAsMap(reader, type, m, count, memberNames);
        return m;
    }

    public static final CaseInsensitiveMap readObjectAsCaseInsensitiveMap(Reader reader, Type type) throws IOException {
        String[] memberNames = reader.readMemberNames();
        int count = memberNames.length;
        CaseInsensitiveMap m = new CaseInsensitiveMap(count);
        ReferenceReader.readObjectAsMap(reader, type, m, count, memberNames);
        return m;
    }

    public static final TreeMap readObjectAsTreeMap(Reader reader, Type type) throws IOException {
        String[] memberNames = reader.readMemberNames();
        int count = memberNames.length;
        TreeMap m = new TreeMap();
        ReferenceReader.readObjectAsMap(reader, type, m, count, memberNames);
        return m;
    }

    public static final Map readObjectAsMap(Reader reader, Type type) throws IOException {
        String[] memberNames = reader.readMemberNames();
        int count = memberNames.length;
        Class<?> cls = ClassUtil.toClass(type);
        Map m = (Map)ConstructorAccessor.newInstance(cls);
        ReferenceReader.readObjectAsMap(reader, type, m, count, memberNames);
        return m;
    }

    public static void readMap(Reader reader, Map<String, Object> m, Map<String, Type> typeMap, int count) throws IOException {
        reader.setRef(m);
        if (count > 0) {
            StringUnserializer keyUnserializer = StringUnserializer.instance;
            for (int i = 0; i < count; ++i) {
                String key = keyUnserializer.read(reader);
                if (typeMap.containsKey(key)) {
                    Type valueType = typeMap.get(key);
                    m.put(key, reader.unserialize(valueType));
                    continue;
                }
                m.put(key, reader.unserialize());
            }
        }
        reader.skip(125);
    }

    public static final Map<String, Object> readMap(Reader reader, Class<? extends Map> type, Map<String, Type> typeMap) throws IOException {
        int count = ValueReader.readCount(reader);
        Map m = ConstructorAccessor.newInstance(type);
        ReferenceReader.readMap(reader, m, typeMap, count);
        return m;
    }

    public static void readMap(Reader reader, Map m, Type keyType, Type valueType, int count) throws IOException {
        reader.setRef(m);
        if (count > 0) {
            InputStream stream = reader.stream;
            Class<?> keyClass = ClassUtil.toClass(keyType);
            Class<?> valueClass = ClassUtil.toClass(valueType);
            Unserializer keyUnserializer = UnserializerFactory.get(keyClass);
            Unserializer valueUnserializer = UnserializerFactory.get(valueClass);
            for (int i = 0; i < count; ++i) {
                Object key = keyUnserializer.read(reader, stream.read(), keyType);
                Object value = valueUnserializer.read(reader, stream.read(), valueType);
                m.put(key, value);
            }
        }
        reader.skip(125);
    }

    public static final Map readMap(Reader reader, Class<? extends Map> type, Type keyType, Type valueType) throws IOException {
        int count = ValueReader.readCount(reader);
        Map m = ConstructorAccessor.newInstance(type);
        ReferenceReader.readMap(reader, m, keyType, valueType, count);
        return m;
    }

    private static void readMap(Reader reader, Type type, Map m, int count) throws IOException {
        ReferenceReader.readMap(reader, m, ClassUtil.getKeyType(type), ClassUtil.getValueType(type), count);
    }

    public static final HashMap readHashMap(Reader reader, Type type) throws IOException {
        int count = ValueReader.readCount(reader);
        HashMap m = new HashMap(count);
        ReferenceReader.readMap(reader, type, m, count);
        return m;
    }

    public static final LinkedHashMap readLinkedHashMap(Reader reader, Type type) throws IOException {
        int count = ValueReader.readCount(reader);
        LinkedHashMap m = new LinkedHashMap(count);
        ReferenceReader.readMap(reader, type, m, count);
        return m;
    }

    public static final LinkedCaseInsensitiveMap readLinkedCaseInsensitiveMap(Reader reader, Type type) throws IOException {
        int count = ValueReader.readCount(reader);
        LinkedCaseInsensitiveMap m = new LinkedCaseInsensitiveMap(count);
        ReferenceReader.readMap(reader, type, m, count);
        return m;
    }

    public static final CaseInsensitiveMap readCaseInsensitiveMap(Reader reader, Type type) throws IOException {
        int count = ValueReader.readCount(reader);
        CaseInsensitiveMap m = new CaseInsensitiveMap(count);
        ReferenceReader.readMap(reader, type, m, count);
        return m;
    }

    public static final TreeMap readTreeMap(Reader reader, Type type) throws IOException {
        int count = ValueReader.readCount(reader);
        TreeMap m = new TreeMap();
        ReferenceReader.readMap(reader, type, m, count);
        return m;
    }

    public static final Map readMap(Reader reader, Type type) throws IOException {
        int count = ValueReader.readCount(reader);
        Class<?> cls = ClassUtil.toClass(type);
        Map m = (Map)ConstructorAccessor.newInstance(cls);
        ReferenceReader.readMap(reader, type, m, count);
        return m;
    }

    public static final Object readMapAsObject(Reader reader, Type type) throws IOException {
        Class<?> cls = ClassUtil.toClass(type);
        Object obj = ConstructorAccessor.newInstance(cls);
        reader.setRef(obj);
        Map<String, MemberAccessor> members = Accessors.getMembers(type, reader.mode);
        int count = ValueReader.readCount(reader);
        StringUnserializer unserializer = StringUnserializer.instance;
        for (int i = 0; i < count; ++i) {
            String memberName = unserializer.read(reader);
            MemberAccessor member = members.get(memberName);
            if (member != null) {
                member.unserialize(reader, obj);
                continue;
            }
            reader.unserialize();
        }
        reader.skip(125);
        return obj;
    }

    private static Object readObject(Reader reader, String[] memberNames, Type type) throws HproseException, IOException {
        Class<?> cls = ClassUtil.toClass(type);
        Object obj = ConstructorAccessor.newInstance(cls);
        reader.setRef(obj);
        Map<String, MemberAccessor> members = Accessors.getMembers(type, reader.mode);
        int count = memberNames.length;
        for (int i = 0; i < count; ++i) {
            MemberAccessor member = members.get(memberNames[i]);
            if (member != null) {
                member.unserialize(reader, obj);
                continue;
            }
            reader.unserialize();
        }
        reader.skip(125);
        return obj;
    }

    private static Object readObjectAsMap(Reader reader, String[] memberNames) throws IOException {
        int count = memberNames.length;
        LinkedCaseInsensitiveMap<String, Object> map = new LinkedCaseInsensitiveMap<String, Object>(count);
        reader.setRef(map);
        for (int i = 0; i < count; ++i) {
            map.put(memberNames[i], reader.unserialize());
        }
        reader.skip(125);
        return map;
    }

    public static final Object readObject(Reader reader, Type type) throws IOException {
        Object cr = reader.readClassRef();
        String[] memberNames = reader.getMemberNames(cr);
        if (Class.class.equals(cr.getClass())) {
            Class c = (Class)cr;
            if (type == null || type instanceof Class && ((Class)type).isAssignableFrom(c)) {
                type = c;
            }
        }
        if (type == null || Object.class.equals((Object)type)) {
            return ReferenceReader.readObjectAsMap(reader, memberNames);
        }
        return ReferenceReader.readObject(reader, memberNames, type);
    }

    public static final Object readObject(Reader reader) throws IOException {
        Object cr = reader.readClassRef();
        String[] memberNames = reader.getMemberNames(cr);
        if (Class.class.equals(cr.getClass())) {
            return ReferenceReader.readObject(reader, memberNames, (Class)cr);
        }
        return ReferenceReader.readObjectAsMap(reader, memberNames);
    }
}

