/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.io.unserialize;

import java.io.IOException;
import java.lang.reflect.Type;
import net.hasor.rsf.hprose.io.convert.StringBuilderConverter;
import net.hasor.rsf.hprose.io.unserialize.BaseUnserializer;
import net.hasor.rsf.hprose.io.unserialize.Reader;
import net.hasor.rsf.hprose.io.unserialize.ReferenceReader;
import net.hasor.rsf.hprose.io.unserialize.ValueReader;

public final class StringBuilderUnserializer
extends BaseUnserializer<StringBuilder> {
    public static final StringBuilderUnserializer instance = new StringBuilderUnserializer();

    @Override
    public StringBuilder unserialize(Reader reader, int tag, Type type) throws IOException {
        StringBuilderConverter converter = StringBuilderConverter.instance;
        switch (tag) {
            case 101: {
                return new StringBuilder();
            }
            case 115: {
                return converter.convertTo(ReferenceReader.readChars(reader));
            }
            case 117: {
                return new StringBuilder().append(ValueReader.readChar(reader));
            }
            case 105: {
                return ValueReader.readUntil(reader, 59);
            }
            case 108: {
                return ValueReader.readUntil(reader, 59);
            }
            case 100: {
                return ValueReader.readUntil(reader, 59);
            }
        }
        if (tag >= 48 && tag <= 57) {
            return new StringBuilder().append((char)tag);
        }
        switch (tag) {
            case 116: {
                return new StringBuilder("true");
            }
            case 102: {
                return new StringBuilder("false");
            }
            case 78: {
                return new StringBuilder("NaN");
            }
            case 73: {
                return new StringBuilder(reader.stream.read() == 43 ? "Infinity" : "-Infinity");
            }
            case 68: {
                return ReferenceReader.readDateTime(reader).toStringBuilder();
            }
            case 84: {
                return ReferenceReader.readTime(reader).toStringBuilder();
            }
            case 103: {
                return new StringBuilder(ReferenceReader.readUUID(reader).toString());
            }
        }
        return (StringBuilder)super.unserialize(reader, tag, type);
    }

    public StringBuilder read(Reader reader) throws IOException {
        return (StringBuilder)this.read(reader, (Type)((Object)StringBuilder.class));
    }
}

