/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.io.unserialize;

import java.io.IOException;
import java.lang.reflect.Type;
import net.hasor.rsf.hprose.io.unserialize.BaseUnserializer;
import net.hasor.rsf.hprose.io.unserialize.Reader;
import net.hasor.rsf.hprose.io.unserialize.ReferenceReader;
import net.hasor.rsf.hprose.io.unserialize.ValueReader;

public final class StringUnserializer
extends BaseUnserializer<String> {
    public static final StringUnserializer instance = new StringUnserializer();

    @Override
    public String unserialize(Reader reader, int tag, Type type) throws IOException {
        switch (tag) {
            case 101: {
                return "";
            }
            case 115: {
                return ReferenceReader.readString(reader);
            }
            case 117: {
                return ValueReader.readUTF8Char(reader);
            }
            case 105: {
                return ValueReader.readUntil(reader, 59).toString();
            }
            case 108: {
                return ValueReader.readUntil(reader, 59).toString();
            }
            case 100: {
                return ValueReader.readUntil(reader, 59).toString();
            }
        }
        if (tag >= 48 && tag <= 57) {
            return String.valueOf((char)tag);
        }
        switch (tag) {
            case 116: {
                return "true";
            }
            case 102: {
                return "false";
            }
            case 78: {
                return "NaN";
            }
            case 73: {
                return reader.stream.read() == 43 ? "Infinity" : "-Infinity";
            }
            case 68: {
                return ReferenceReader.readDateTime(reader).toString();
            }
            case 84: {
                return ReferenceReader.readTime(reader).toString();
            }
            case 103: {
                return ReferenceReader.readUUID(reader).toString();
            }
        }
        return (String)super.unserialize(reader, tag, type);
    }

    public String read(Reader reader) throws IOException {
        return (String)this.read(reader, (Type)((Object)String.class));
    }
}

