/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.io.unserialize;

import java.io.IOException;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import net.hasor.rsf.hprose.io.unserialize.BaseUnserializer;
import net.hasor.rsf.hprose.io.unserialize.Reader;
import net.hasor.rsf.hprose.io.unserialize.ReferenceReader;
import net.hasor.rsf.hprose.io.unserialize.ValueReader;

public final class TimestampUnserializer
extends BaseUnserializer<Timestamp> {
    public static final TimestampUnserializer instance = new TimestampUnserializer();

    @Override
    public Timestamp unserialize(Reader reader, int tag, Type type) throws IOException {
        switch (tag) {
            case 68: {
                return ReferenceReader.readDateTime(reader).toTimestamp();
            }
            case 84: {
                return ReferenceReader.readTime(reader).toTimestamp();
            }
            case 101: {
                return null;
            }
            case 115: {
                return Timestamp.valueOf(ReferenceReader.readString(reader));
            }
            case 105: 
            case 108: {
                return new Timestamp(ValueReader.readLong(reader));
            }
            case 100: {
                return new Timestamp((long)ValueReader.readDouble(reader));
            }
        }
        if (tag >= 48 && tag <= 57) {
            return new Timestamp(tag - 48);
        }
        return (Timestamp)super.unserialize(reader, tag, type);
    }

    public Timestamp read(Reader reader) throws IOException {
        return (Timestamp)this.read(reader, (Type)((Object)Timestamp.class));
    }
}

