/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.server;

import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import javax.websocket.EndpointConfig;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import net.hasor.rsf.hprose.common.HproseContext;
import net.hasor.rsf.hprose.common.HproseMethods;
import net.hasor.rsf.hprose.io.ByteBufferStream;
import net.hasor.rsf.hprose.server.HproseService;
import net.hasor.rsf.hprose.server.HproseWebSocketMethods;
import net.hasor.rsf.hprose.server.ServiceContext;
import net.hasor.rsf.hprose.server.WebSocketContext;
import net.hasor.rsf.hprose.util.concurrent.Action;

public class HproseWebSocketService
extends HproseService {
    private static final ThreadLocal<WebSocketContext> currentContext = new ThreadLocal();
    private EndpointConfig config = null;

    public static WebSocketContext getCurrentContext() {
        return currentContext.get();
    }

    @Override
    public HproseMethods getGlobalMethods() {
        if (this.globalMethods == null) {
            this.globalMethods = new HproseWebSocketMethods();
        }
        return this.globalMethods;
    }

    @Override
    public void setGlobalMethods(HproseMethods methods) {
        if (!(methods instanceof HproseWebSocketMethods)) {
            throw new ClassCastException("methods must be a HproseWebSocketMethods instance");
        }
        this.globalMethods = methods;
    }

    @Override
    protected Object[] fixArguments(Type[] argumentTypes, Object[] arguments, ServiceContext context) {
        int count = arguments.length;
        WebSocketContext wsContext = (WebSocketContext)context;
        if (argumentTypes.length != count) {
            Object[] args = new Object[argumentTypes.length];
            System.arraycopy(arguments, 0, args, 0, count);
            Class argType = (Class)argumentTypes[count];
            if (argType.equals(HproseContext.class) || argType.equals(ServiceContext.class)) {
                args[count] = context;
            } else if (argType.equals(WebSocketContext.class)) {
                args[count] = wsContext;
            } else if (argType.equals(EndpointConfig.class)) {
                args[count] = wsContext.getConfig();
            } else if (argType.equals(Session.class)) {
                args[count] = wsContext.getSession();
            }
            return args;
        }
        return arguments;
    }

    public void setConfig(EndpointConfig config) {
        this.config = config;
    }

    public void handle(final ByteBuffer buf, final Session session) throws IOException {
        WebSocketContext context = new WebSocketContext(this, session, this.config);
        final int id = buf.getInt();
        currentContext.set(context);
        this.handle(buf.slice(), context).then(new Action<ByteBuffer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void call(ByteBuffer value) throws Throwable {
                try {
                    ByteBuffer buffer = ByteBuffer.allocate(4);
                    buffer.putInt(id);
                    buffer.flip();
                    RemoteEndpoint.Basic remote = session.getBasicRemote();
                    remote.sendBinary(buffer, false);
                    remote.sendBinary(value, true);
                }
                finally {
                    ByteBufferStream.free(value);
                }
            }
        }).whenComplete(new Runnable(){

            @Override
            public void run() {
                currentContext.remove();
                ByteBufferStream.free(buf);
            }
        });
    }

    public void handleError(Session session, Throwable error) {
        WebSocketContext context = new WebSocketContext(this, session, this.config);
        this.fireErrorEvent(error, context);
    }
}

