/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.protocol.http_hprose;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;
import net.hasor.core.AppContext;
import net.hasor.rsf.InterAddress;
import net.hasor.rsf.RsfContext;
import net.hasor.rsf.domain.RequestInfo;
import net.hasor.rsf.domain.ResponseInfo;
import net.hasor.rsf.domain.RsfException;
import net.hasor.rsf.hprose.io.HproseWriter;
import net.hasor.rsf.protocol.http_hprose.HproseUtils;
import net.hasor.rsf.rpc.net.Connector;
import net.hasor.rsf.rpc.net.http.HttpHandler;
import net.hasor.rsf.rpc.net.http.HttpHandlerFactory;
import net.hasor.rsf.rpc.net.http.RequestBuilder;
import net.hasor.rsf.rpc.net.http.RequestObject;
import net.hasor.rsf.rpc.net.http.RsfHttpRequest;
import net.hasor.rsf.rpc.net.http.RsfHttpResponse;
import net.hasor.rsf.rpc.net.http.RsfHttpResponseData;
import net.hasor.rsf.utils.IOUtils;
import net.hasor.rsf.utils.ProtocolUtils;

public class HproseHttpHandler
implements HttpHandler,
HttpHandlerFactory {
    private String contextPath;
    private Connector connector;
    private RsfContext rsfContext;

    public HproseHttpHandler() {
    }

    @Override
    public HttpHandler newHandler(String contextPath, Connector connector, AppContext appContext) {
        return new HproseHttpHandler(contextPath, connector, appContext);
    }

    public HproseHttpHandler(String contextPath, Connector connector, AppContext appContext) {
        this.contextPath = contextPath;
        this.connector = connector;
        this.rsfContext = (RsfContext)appContext.getInstance(RsfContext.class);
    }

    @Override
    public void receivedRequest(RsfHttpRequest httpRequest, RsfHttpResponse httpResponse, HttpHandler.HttpResult outputTo) throws IOException {
        String requestURI = httpRequest.getRequestURI();
        if (!requestURI.startsWith(this.contextPath)) {
            httpResponse.sendError(404, "not found service.");
            return;
        }
        final String originString = httpRequest.getHeader("Origin");
        this.httpOrigin(originString, httpResponse);
        String origin = httpRequest.getHeader("Origin");
        InputStream inputStream = httpRequest.getInputStream();
        int aByte = inputStream.read();
        if ((char)aByte == 'z') {
            String[] nameArrays = HproseUtils.doFunction(this.rsfContext);
            OutputStream outputStream = httpResponse.getOutputStream();
            outputStream.write(new byte[]{70});
            new HproseWriter(outputStream).writeArray(nameArrays);
            outputStream.write(new byte[]{122});
            httpResponse.flushBuffer();
            outputTo.finishRPC();
            return;
        }
        if ((char)aByte == 'C') {
            RequestInfo[] info = HproseUtils.doCall(this.rsfContext, inputStream, requestURI, origin);
            if (info.length == 0) {
                throw new RsfException(506, "undefined calls.");
            }
            if (info.length != 1) {
                throw new RsfException(506, "not support multiple calls.");
            }
            HttpHandler.ResponseEncoder responseEncoder = new HttpHandler.ResponseEncoder(){

                @Override
                public void exception(RsfHttpResponse httpResponse, Throwable e) throws IOException {
                    HproseHttpHandler.this.onException(originString, httpResponse, e);
                }

                @Override
                public void complete(RsfHttpResponse httpResponse, ResponseInfo info) throws IOException {
                    HproseHttpHandler.this.onComplete(originString, httpResponse, info);
                }
            };
            outputTo.callRPC(info[0], responseEncoder);
            return;
        }
        throw new RsfException(506, "command error. -> " + aByte);
    }

    private void onException(String originString, RsfHttpResponse httpResponse, Throwable e) throws IOException {
        this.httpOrigin(originString, httpResponse);
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        new OutputStreamWriter(httpResponse.getOutputStream(), "UTF-8").write(sw.toString());
    }

    private void onComplete(String originString, RsfHttpResponse httpResponse, ResponseInfo info) throws IOException {
        this.httpOrigin(originString, httpResponse);
        if (info != null) {
            HproseUtils.parseResponse(-1L, info, httpResponse.getOutputStream());
        }
    }

    protected void httpOrigin(String originString, RsfHttpResponse httpResponse) {
        httpResponse.setContentType("application/hprose");
        if (originString != null && !originString.equals("null")) {
            httpResponse.setHeader("Access-Control-Allow-Origin", originString);
            httpResponse.setHeader("Access-Control-Allow-Credentials", "true");
        } else {
            httpResponse.setHeader("Access-Control-Allow-Origin", "*");
        }
    }

    @Override
    public void sendRequest(InterAddress server, RequestInfo info, HttpHandler.SenderBuilder builder) throws Throwable {
        String group = URLEncoder.encode(info.getServiceGroup(), "UTF-8");
        String name = URLEncoder.encode(info.getServiceName(), "UTF-8");
        String version = URLEncoder.encode(info.getServiceVersion(), "UTF-8");
        String pathInfo = ("/" + group + "/" + name + "/" + version).replaceAll("/{2,}", "/");
        URL requestURL = new URL("http", server.getHost(), server.getPort(), pathInfo);
        ByteBuf byteBuf = HproseUtils.encodeRequest(this.rsfContext, info);
        ByteBufInputStream inputStream = new ByteBufInputStream(byteBuf);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)inputStream, (OutputStream)out);
        RequestBuilder requestBuilder = RequestBuilder.newBuild("GET", requestURL);
        requestBuilder.setContentData(out.toByteArray());
        for (String optKey : info.getOptionKeys()) {
            requestBuilder.addHeader(optKey, info.getOption(optKey));
        }
        RequestObject httpObject = requestBuilder.buildObject();
        builder.sendRequest(httpObject, this::decodeResponseInfo);
    }

    private ResponseInfo decodeResponseInfo(long requestID, RsfHttpResponseData httpResponse) throws IOException {
        short responseStatus = (short)httpResponse.getStatus();
        if (httpResponse.getStatus() != 200) {
            String errorInfo = httpResponse.getStatusMessage();
            return ProtocolUtils.buildResponseStatus(null, requestID, responseStatus, errorInfo);
        }
        Object result = HproseUtils.decodeResponse(httpResponse.getInputStream());
        ResponseInfo responseInfo = new ResponseInfo();
        Collection<String> headerNames = httpResponse.getHeaderNames();
        for (String optKey : headerNames) {
            responseInfo.addOption(optKey, httpResponse.getHeader(optKey));
        }
        responseInfo.setReceiveTime(System.currentTimeMillis());
        responseInfo.setRequestID(requestID);
        responseInfo.setStatus(responseStatus);
        responseInfo.setSerializeType("Hprose");
        responseInfo.setReturnType("");
        responseInfo.setReturnData(result);
        return responseInfo;
    }
}

