/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.protocol.rsf;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import net.hasor.rsf.RsfEnvironment;
import net.hasor.rsf.domain.RequestInfo;
import net.hasor.rsf.domain.ResponseInfo;
import net.hasor.rsf.protocol.rsf.CodecAdapter;
import net.hasor.rsf.protocol.rsf.CodecAdapterFactory;
import net.hasor.rsf.protocol.rsf.ProtocolConstants;
import net.hasor.rsf.utils.ProtocolUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RsfDecoder
extends LengthFieldBasedFrameDecoder
implements ProtocolConstants {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private RsfEnvironment rsfEnvironment;
    private ClassLoader classLoader;

    public RsfDecoder(RsfEnvironment rsfEnvironment, int maxBodyLength, ClassLoader classLoader) {
        super(maxBodyLength, 10, 3, 0, 0);
        this.rsfEnvironment = rsfEnvironment;
        this.classLoader = classLoader;
    }

    protected Object decode(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        ByteBuf frame = (ByteBuf)super.decode(ctx, in);
        if (frame == null) {
            return null;
        }
        byte rsfHead = frame.getByte(0);
        short status = this.doDecode(rsfHead, ctx, frame);
        if (status != 200) {
            frame = frame.resetReaderIndex().skipBytes(1);
            long requestID = frame.readLong();
            ResponseInfo info = ProtocolUtils.buildResponseStatus(this.rsfEnvironment, requestID, status, null);
            ctx.pipeline().writeAndFlush((Object)info);
        }
        return null;
    }

    protected ByteBuf extractFrame(ChannelHandlerContext ctx, ByteBuf buffer, int index, int length) {
        return buffer.slice(index, length);
    }

    private short doDecode(byte rsfHead, ChannelHandlerContext ctx, ByteBuf frame) {
        CodecAdapter factory = CodecAdapterFactory.getCodecAdapterByVersion(this.rsfEnvironment, this.classLoader, (byte)(rsfHead & 0xF));
        if (-111 == rsfHead) {
            try {
                RequestInfo info = factory.readRequestInfo(frame);
                info.setReceiveTime(System.currentTimeMillis());
                info.setMessage(false);
                ctx.fireChannelRead((Object)info);
                return 200;
            }
            catch (Throwable e) {
                this.logger.error("decode request error :" + e.getMessage(), e);
                return 506;
            }
        }
        if (-95 == rsfHead) {
            try {
                RequestInfo info = factory.readRequestInfo(frame);
                info.setReceiveTime(System.currentTimeMillis());
                info.setMessage(true);
                ctx.fireChannelRead((Object)info);
                return 200;
            }
            catch (Throwable e) {
                this.logger.error("decode request error :" + e.getMessage(), e);
                return 506;
            }
        }
        if (-79 == rsfHead) {
            try {
                ResponseInfo info = factory.readResponseInfo(frame);
                info.setReceiveTime(System.currentTimeMillis());
                ctx.fireChannelRead((Object)info);
                return 200;
            }
            catch (Throwable e) {
                this.logger.error("decode response error :" + e.getMessage(), e);
                return 506;
            }
        }
        return 505;
    }
}

