/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.protocol.rsf;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import net.hasor.rsf.RsfEnvironment;
import net.hasor.rsf.domain.RequestInfo;
import net.hasor.rsf.domain.ResponseInfo;
import net.hasor.rsf.protocol.rsf.CodecAdapter;
import net.hasor.rsf.protocol.rsf.CodecAdapterFactory;
import net.hasor.rsf.protocol.rsf.ProtocolConstants;
import net.hasor.rsf.protocol.rsf.v1.PoolBlock;
import net.hasor.rsf.protocol.rsf.v1.RequestBlock;
import net.hasor.rsf.protocol.rsf.v1.ResponseBlock;

public class RsfEncoder
extends MessageToByteEncoder<Object>
implements ProtocolConstants {
    private RsfEnvironment rsfEnvironment;
    private ClassLoader classLoader;

    public RsfEncoder(RsfEnvironment rsfEnvironment, ClassLoader classLoader) {
        this.rsfEnvironment = rsfEnvironment;
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encode(ChannelHandlerContext ctx, Object msg, ByteBuf out) throws Exception {
        PoolBlock block = null;
        try {
            CodecAdapter factory = CodecAdapterFactory.getCodecAdapterByVersion(this.rsfEnvironment, this.classLoader, (byte)1);
            if (msg instanceof RequestInfo) {
                RequestInfo info = (RequestInfo)msg;
                block = factory.buildRequestBlock(info);
                factory.wirteRequestBlock((RequestBlock)block, out);
                return;
            }
            if (msg instanceof ResponseInfo) {
                ResponseInfo info = (ResponseInfo)msg;
                block = factory.buildResponseBlock(info);
                factory.wirteResponseBlock((ResponseBlock)block, out);
                return;
            }
            if (msg instanceof RequestBlock) {
                block = (RequestBlock)msg;
                factory.wirteRequestBlock((RequestBlock)block, out);
                return;
            }
            if (msg instanceof ResponseBlock) {
                block = (ResponseBlock)msg;
                factory.wirteResponseBlock((ResponseBlock)block, out);
                return;
            }
        }
        catch (Exception e) {
            ctx.fireExceptionCaught((Throwable)e);
        }
        finally {
            ctx.flush();
            if (block != null) {
                block.release();
            }
        }
    }
}

