/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.protocol.rsf;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import net.hasor.rsf.InterAddress;
import net.hasor.rsf.RsfEnvironment;
import net.hasor.rsf.domain.ResponseInfo;
import net.hasor.rsf.rpc.net.Connector;
import net.hasor.rsf.utils.ProtocolUtils;
import net.hasor.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShakeHands
extends ChannelInboundHandlerAdapter {
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
    private final InterAddress bindAddress;
    private final RsfEnvironment rsfEnvironment;

    public ShakeHands(Connector connector) {
        this.rsfEnvironment = connector.getRsfEnvironment();
        this.bindAddress = connector.getBindAddress();
    }

    public void channelActive(final ChannelHandlerContext ctx) throws Exception {
        this.atomicBoolean.set(false);
        this.rsfEnvironment.atTime(new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                if (ShakeHands.this.atomicBoolean.get()) {
                    return;
                }
                ProtocolUtils.buildResponseStatus(ShakeHands.this.rsfEnvironment, -1L, (short)408, "shake hands with timeout.");
                ResponseInfo options = new ResponseInfo();
                options.setRequestID(-1L);
                options.setStatus((short)200);
                ctx.close();
                ShakeHands.this.logger.error("shake hands with timeout. ->" + ctx.channel().remoteAddress());
            }
        }, 3000);
        ResponseInfo options = new ResponseInfo();
        options.setRequestID(-1L);
        options.setStatus((short)200);
        options.addOption("SERVER_INFO", this.bindAddress.toHostSchema());
        ctx.writeAndFlush((Object)options);
        super.channelActive(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!this.atomicBoolean.get()) {
            ResponseInfo responseInfo;
            String serverInfo;
            if (msg instanceof ResponseInfo && StringUtils.isNotBlank((String)(serverInfo = (responseInfo = (ResponseInfo)msg).getOption("SERVER_INFO")))) {
                this.logger.info("shake hands successful. ->" + ctx.channel().remoteAddress());
                this.atomicBoolean.set(true);
            }
            return;
        }
        super.channelRead(ctx, msg);
    }
}

