/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.protocol.rsf.v1;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import net.hasor.rsf.RsfEnvironment;
import net.hasor.rsf.SerializeCoder;
import net.hasor.rsf.domain.RequestInfo;
import net.hasor.rsf.domain.ResponseInfo;
import net.hasor.rsf.protocol.rsf.CodecAdapter;
import net.hasor.rsf.protocol.rsf.Protocol;
import net.hasor.rsf.protocol.rsf.ProtocolConstants;
import net.hasor.rsf.protocol.rsf.v1.PoolBlock;
import net.hasor.rsf.protocol.rsf.v1.RequestBlock;
import net.hasor.rsf.protocol.rsf.v1.ResponseBlock;
import net.hasor.rsf.protocol.rsf.v1.RpcRequestProtocolV1;
import net.hasor.rsf.protocol.rsf.v1.RpcResponseProtocolV1;
import net.hasor.rsf.utils.ByteStringCachelUtils;
import net.hasor.utils.ClassUtils;
import net.hasor.utils.StringUtils;

public class CodecAdapterForV1
implements CodecAdapter,
ProtocolConstants {
    private RsfEnvironment rsfEnvironment = null;
    private ClassLoader classLoader = null;
    private Protocol<RequestBlock> requestProtocol = new RpcRequestProtocolV1();
    private Protocol<ResponseBlock> responseProtocol = new RpcResponseProtocolV1();

    public CodecAdapterForV1(RsfEnvironment rsfEnvironment, ClassLoader classLoader) {
        this.rsfEnvironment = rsfEnvironment;
        this.classLoader = classLoader;
    }

    @Override
    public RequestBlock buildRequestBlock(RequestInfo info) throws IOException {
        String[] optKeys;
        int i;
        RequestBlock block = new RequestBlock();
        if (info.isMessage()) {
            block.setHead((byte)-95);
        } else {
            block.setHead((byte)-111);
        }
        block.setRequestID(info.getRequestID());
        block.setFlags(info.getFlags());
        block.setServiceGroup(CodecAdapterForV1.pushString(block, info.getServiceGroup()));
        block.setServiceName(CodecAdapterForV1.pushString(block, info.getServiceName()));
        block.setServiceVersion(CodecAdapterForV1.pushString(block, info.getServiceVersion()));
        block.setTargetMethod(CodecAdapterForV1.pushString(block, info.getTargetMethod()));
        block.setSerializeType(CodecAdapterForV1.pushString(block, info.getSerializeType()));
        block.setClientTimeout(info.getClientTimeout());
        List<String> pTypes = info.getParameterTypes();
        List<Object> pValues = info.getParameterValues();
        if (pTypes != null && !pTypes.isEmpty() && pValues != null && !pValues.isEmpty()) {
            SerializeCoder coder = this.rsfEnvironment.getSerializeCoder(info.getSerializeType());
            for (i = 0; i < pTypes.size(); ++i) {
                String typeKey = pTypes.get(i);
                Object value = pValues.get(i);
                byte[] valKey = coder != null ? coder.encode(value) : new byte[]{};
                short paramType = CodecAdapterForV1.pushString(block, typeKey);
                short paramData = CodecAdapterForV1.pushBytes(block, valKey);
                block.addParameter(paramType, paramData);
            }
        }
        if ((optKeys = info.getOptionKeys()).length > 0) {
            for (i = 0; i < optKeys.length; ++i) {
                short optKey = CodecAdapterForV1.pushString(block, optKeys[i]);
                short optVal = CodecAdapterForV1.pushString(block, info.getOption(optKeys[i]));
                block.addOption(optKey, optVal);
            }
        }
        return block;
    }

    @Override
    public ResponseBlock buildResponseBlock(ResponseInfo info) throws IOException {
        String[] optKeys;
        ResponseBlock block = new ResponseBlock();
        block.setHead((byte)-79);
        block.setRequestID(info.getRequestID());
        block.setSerializeType(CodecAdapterForV1.pushString(block, info.getSerializeType()));
        String returnType = info.getReturnType();
        SerializeCoder serializeCoder = this.rsfEnvironment.getSerializeCoder(info.getSerializeType());
        byte[] encode = serializeCoder != null ? serializeCoder.encode(info.getReturnData()) : new byte[]{};
        block.setReturnData(block.pushData(encode));
        block.setReturnType(CodecAdapterForV1.pushString(block, returnType));
        block.setReturnData(block.pushData(encode));
        block.setStatus(info.getStatus());
        for (String optKey1 : optKeys = info.getOptionKeys()) {
            short optKey = CodecAdapterForV1.pushString(block, optKey1);
            short optVal = CodecAdapterForV1.pushString(block, info.getOption(optKey1));
            block.addOption(optKey, optVal);
        }
        return block;
    }

    private static short pushBytes(PoolBlock socketMessage, byte[] attrData) {
        if (attrData != null) {
            return socketMessage.pushData(attrData);
        }
        return socketMessage.pushData(null);
    }

    private static short pushString(PoolBlock socketMessage, String attrData) {
        if (attrData != null) {
            return socketMessage.pushData(ByteStringCachelUtils.fromCache(attrData));
        }
        return socketMessage.pushData(null);
    }

    @Override
    public void wirteRequestBlock(RequestBlock block, ByteBuf out) throws IOException {
        this.requestProtocol.encode(block, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestInfo readRequestInfo(ByteBuf frame) throws Throwable {
        RequestBlock rsfBlock = this.requestProtocol.decode(frame);
        RequestInfo info = new RequestInfo();
        try {
            int[] optionArray;
            info.setRequestID(rsfBlock.getRequestID());
            short serializeTypeInt = rsfBlock.getSerializeType();
            String serializeType = ByteStringCachelUtils.fromCache(rsfBlock.readPool(serializeTypeInt));
            info.setSerializeType(serializeType);
            if (rsfBlock.getHead() == -111) {
                info.setMessage(false);
            }
            if (rsfBlock.getHead() == -95) {
                info.setMessage(true);
            }
            if ((optionArray = rsfBlock.getOptions()).length > 0) {
                for (int optItem : optionArray) {
                    short optKey = (short)(optItem >>> 16);
                    short optVal = (short)(optItem & PoolBlock.PoolMaxSize);
                    String optKeyStr = ByteStringCachelUtils.fromCache(rsfBlock.readPool(optKey));
                    String optValStr = ByteStringCachelUtils.fromCache(rsfBlock.readPool(optVal));
                    info.addOption(optKeyStr, optValStr);
                }
            }
            String serviceGroup = ByteStringCachelUtils.fromCache(rsfBlock.readPool(rsfBlock.getServiceGroup()));
            String serviceName = ByteStringCachelUtils.fromCache(rsfBlock.readPool(rsfBlock.getServiceName()));
            String serviceVersion = ByteStringCachelUtils.fromCache(rsfBlock.readPool(rsfBlock.getServiceVersion()));
            String targetMethod = ByteStringCachelUtils.fromCache(rsfBlock.readPool(rsfBlock.getTargetMethod()));
            int clientTimeout = rsfBlock.getClientTimeout();
            info.setServiceGroup(serviceGroup);
            info.setServiceName(serviceName);
            info.setServiceVersion(serviceVersion);
            info.setTargetMethod(targetMethod);
            info.setClientTimeout(clientTimeout);
            int[] paramDatas = rsfBlock.getParameters();
            SerializeCoder serializeCoder = this.rsfEnvironment.getSerializeCoder(serializeType);
            if (paramDatas.length > 0) {
                for (int i = 0; i < paramDatas.length; ++i) {
                    int paramItem = paramDatas[i];
                    short paramKey = (short)(paramItem >>> 16);
                    short paramVal = (short)(paramItem & PoolBlock.PoolMaxSize);
                    byte[] keyData = rsfBlock.readPool(paramKey);
                    byte[] valData = rsfBlock.readPool(paramVal);
                    String paramType = ByteStringCachelUtils.fromCache(keyData);
                    Object paramObj = null;
                    if (serializeCoder != null && StringUtils.isNotBlank((String)paramType)) {
                        paramObj = serializeCoder.decode(valData, ClassUtils.getClass((ClassLoader)this.classLoader, (String)paramType, (boolean)false));
                    }
                    info.addParameter(paramType, paramObj);
                }
            }
        }
        finally {
            if (rsfBlock != null) {
                rsfBlock.release();
            }
        }
        return info;
    }

    @Override
    public void wirteResponseBlock(ResponseBlock block, ByteBuf out) throws IOException {
        this.responseProtocol.encode(block, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseInfo readResponseInfo(ByteBuf frame) throws Throwable {
        ResponseBlock rsfBlock = this.responseProtocol.decode(frame);
        ResponseInfo info = new ResponseInfo();
        try {
            int[] optionArray;
            info.setRequestID(rsfBlock.getRequestID());
            short serializeTypeInt = rsfBlock.getSerializeType();
            String serializeType = ByteStringCachelUtils.fromCache(rsfBlock.readPool(serializeTypeInt));
            info.setSerializeType(serializeType);
            for (int optItem : optionArray = rsfBlock.getOptions()) {
                short optKey = (short)(optItem >>> 16);
                short optVal = (short)(optItem & PoolBlock.PoolMaxSize);
                String optKeyStr = ByteStringCachelUtils.fromCache(rsfBlock.readPool(optKey));
                String optValStr = ByteStringCachelUtils.fromCache(rsfBlock.readPool(optVal));
                info.addOption(optKeyStr, optValStr);
            }
            info.setStatus(rsfBlock.getStatus());
            SerializeCoder serializeCoder = this.rsfEnvironment.getSerializeCoder(serializeType);
            String returnType = ByteStringCachelUtils.fromCache(rsfBlock.readPool(rsfBlock.getReturnType()));
            info.setReturnType(returnType);
            byte[] returnByte = rsfBlock.readPool(rsfBlock.getReturnData());
            Object returnData = null;
            if (serializeCoder != null && StringUtils.isNotBlank((String)returnType)) {
                returnData = serializeCoder.decode(returnByte, ClassUtils.getClass((ClassLoader)this.classLoader, (String)returnType, (boolean)false));
            }
            info.setReturnData(returnData);
        }
        finally {
            if (rsfBlock != null) {
                rsfBlock.release();
            }
        }
        return info;
    }
}

