/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.rpc.caller;

import io.netty.util.TimerTask;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.hasor.rsf.InterAddress;
import net.hasor.rsf.RsfBindInfo;
import net.hasor.rsf.RsfContext;
import net.hasor.rsf.RsfEnvironment;
import net.hasor.rsf.RsfFilter;
import net.hasor.rsf.RsfFuture;
import net.hasor.rsf.RsfRequest;
import net.hasor.rsf.RsfResponse;
import net.hasor.rsf.RsfResult;
import net.hasor.rsf.RsfSettings;
import net.hasor.rsf.SendLimitPolicy;
import net.hasor.rsf.container.RsfBeanContainer;
import net.hasor.rsf.domain.RequestInfo;
import net.hasor.rsf.domain.ResponseInfo;
import net.hasor.rsf.domain.RsfException;
import net.hasor.rsf.domain.RsfResultDO;
import net.hasor.rsf.domain.RsfTimeoutException;
import net.hasor.rsf.rpc.caller.RsfFilterHandler;
import net.hasor.rsf.rpc.caller.RsfRequestFormLocal;
import net.hasor.rsf.rpc.caller.RsfResponseObject;
import net.hasor.rsf.rpc.caller.SenderListener;
import net.hasor.rsf.rpc.net.SendCallBack;
import net.hasor.rsf.utils.ProtocolUtils;
import net.hasor.utils.future.FutureCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RsfRequestManager {
    protected static Logger logger = LoggerFactory.getLogger(RsfRequestManager.class);
    protected static Logger invLogger = LoggerFactory.getLogger((String)"rsf-invoker");
    private final ConcurrentMap<Long, RsfFuture> rsfResponse;
    private final RsfContext rsfContext;
    private final AtomicInteger requestCount;
    private final SenderListener senderListener;

    public RsfRequestManager(RsfContext rsfContext, SenderListener senderListener) {
        senderListener = Objects.requireNonNull(senderListener, "not found SendData.");
        this.rsfContext = rsfContext;
        this.rsfResponse = new ConcurrentHashMap<Long, RsfFuture>();
        this.requestCount = new AtomicInteger(0);
        this.senderListener = senderListener;
    }

    public RsfContext getContext() {
        return this.rsfContext;
    }

    public abstract RsfBeanContainer getContainer();

    private void sendData(InterAddress toAddress, RequestInfo info, SendCallBack callBack) {
        this.senderListener.sendRequest(toAddress, info, callBack);
    }

    public RsfFuture getRequest(long requestID) {
        return (RsfFuture)((Object)this.rsfResponse.get(requestID));
    }

    public boolean putResponse(ResponseInfo info) {
        long requestID = info.getRequestID();
        RsfFuture rsfFuture = (RsfFuture)((Object)this.rsfResponse.get(requestID));
        if (rsfFuture == null) {
            invLogger.warn("response({}) -> timeoutFailed, RsfFuture is not exist. -> maybe is timeout!", (Object)requestID);
            return false;
        }
        if (info.getStatus() == 102 && !rsfFuture.getRequest().isMessage()) {
            invLogger.info("response({}) -> ignore, rpcType = Invoke, status = Accept", (Object)requestID);
            return true;
        }
        rsfFuture = this.removeRsfFuture(requestID);
        if (rsfFuture == null) {
            invLogger.warn("response({}) -> timeoutFailed, RsfFuture is not exist. -> maybe is timeout!", (Object)requestID);
            return false;
        }
        RsfRequest rsfRequest = rsfFuture.getRequest();
        RsfResponseObject local = new RsfResponseObject(rsfRequest);
        local.addOptionMap(info);
        local.sendStatus(info.getStatus());
        String serializeType = info.getSerializeType();
        String bindID = local.getBindInfo().getBindID();
        Method callMethod = rsfRequest.getMethod();
        invLogger.info("response({}) -> receiveTime ={}, serializeType ={}, status ={}, isMessage ={}, bindID ={}, callMethod ={}.", new Object[]{requestID, info.getReceiveTime(), serializeType, info.getStatus(), rsfRequest.isMessage(), bindID, callMethod});
        if (rsfRequest.isMessage()) {
            Class<RsfResult> returnType = rsfRequest.getMethod().getReturnType();
            RsfResultDO returnObject = null;
            if (info.getStatus() == 102) {
                returnObject = new RsfResultDO(requestID, true);
            } else {
                returnObject = new RsfResultDO(requestID, false);
                returnObject.setErrorCode(info.getStatus());
                returnObject.setErrorMessage(info.getOption("message"));
            }
            if (returnObject.isSuccess()) {
                invLogger.info("response({}) -> successful.", (Object)requestID);
                if (returnType.isAssignableFrom(RsfResult.class)) {
                    local.sendData(returnObject);
                    return rsfFuture.completed(local);
                }
                if (returnObject.isSuccess()) {
                    local.sendData(null);
                    return rsfFuture.completed(local);
                }
            }
            String errorInfo = "errorCode = " + returnObject.getErrorCode() + ", errorMessage=" + returnObject.getErrorMessage();
            invLogger.error("response({}) -> invokeFailed, {}", (Object)requestID, (Object)errorInfo);
            return rsfFuture.failed(new RsfException(local.getStatus(), errorInfo));
        }
        if (info.getStatus() == 200) {
            local.sendData(info.getReturnData());
            return rsfFuture.completed(local);
        }
        invLogger.error("response({}) -> statusFailed, bindID ={}, status ={}.", new Object[]{requestID, bindID, local.getStatus()});
        return rsfFuture.failed(new RsfException(local.getStatus(), "status."));
    }

    public void putResponse(long requestID, Throwable e) {
        RsfFuture rsfFuture = this.removeRsfFuture(requestID);
        if (rsfFuture != null) {
            invLogger.error("response({}) -> errorFailed, {}", new Object[]{requestID, e.getMessage(), e});
            rsfFuture.failed(e);
        } else {
            invLogger.error("response({}) -> errorFailed, RsfFuture is not exist. -> maybe is timeout! ,error= {}.", new Object[]{requestID, e.getMessage(), e});
        }
    }

    private RsfFuture removeRsfFuture(long requestID) {
        RsfFuture rsfFuture = (RsfFuture)((Object)this.rsfResponse.remove(requestID));
        if (rsfFuture != null) {
            this.requestCount.decrementAndGet();
        }
        return rsfFuture;
    }

    protected RsfFuture doSendRequest(RsfRequestFormLocal rsfRequest, FutureCallback<RsfResponse> listener) {
        RsfBindInfo<?> bindInfo = rsfRequest.getBindInfo();
        String serviceID = bindInfo.getBindID();
        RsfFuture rsfFuture = new RsfFuture(rsfRequest, listener);
        invLogger.info("request({}) -> doSendRequest, bindID ={}, callMethod ={}, isMessage ={}.", new Object[]{rsfRequest.getRequestID(), serviceID, rsfRequest.getMethod(), bindInfo.isMessage()});
        rsfRequest.addOptionMap(this.getContext().getSettings().getClientOption());
        try {
            RsfResponseObject res = new RsfResponseObject(rsfRequest);
            Supplier<RsfFilter>[] rsfFilterList = this.getContainer().getFilterProviders(serviceID);
            new RsfFilterHandler(rsfFilterList, (request, response) -> {
                if (response.isResponse()) {
                    invLogger.info("request({}) -> sendRequest, response form local.", (Object)request.getRequestID());
                    rsfFuture.completed(response);
                } else {
                    invLogger.info("request({}) -> sendRequest, response wait for remote.", (Object)request.getRequestID());
                    this.sendRequest(rsfFuture);
                }
            }).doFilter(rsfRequest, res);
        }
        catch (Throwable e) {
            invLogger.error("request({}) -> errorFailed, sendRequest, doRsfFilterChain. error ={}.", new Object[]{rsfRequest.getRequestID(), e.getMessage(), e});
            try {
                rsfFuture.failed(e);
            }
            catch (Throwable e2) {
                logger.error("request({}) -> {}.", new Object[]{rsfRequest.getRequestID(), e2.getMessage(), e2});
            }
        }
        return rsfFuture;
    }

    private void sendRequest(RsfFuture rsfFuture) throws Throwable {
        InterAddress toAddress;
        RsfRequestFormLocal rsfRequest = (RsfRequestFormLocal)rsfFuture.getRequest();
        String serviceID = rsfRequest.getBindInfo().getBindID();
        invLogger.info("request({}) -> bindID ={}, callMethod ={}, serializeType ={}, isMessage ={}, isP2PCalls ={}.", new Object[]{rsfRequest.getRequestID(), serviceID, rsfRequest.getMethod(), rsfRequest.getSerializeType(), rsfRequest.isMessage(), rsfRequest.isP2PCalls()});
        RsfSettings rsfSettings = this.getContainer().getEnvironment().getSettings();
        if (this.requestCount.get() >= rsfSettings.getMaximumRequest()) {
            SendLimitPolicy sendPolicy = rsfSettings.getSendLimitPolicy();
            String errorMessage = "request(" + rsfRequest.getRequestID() + ") -> sendDataFailed, maximum number of requests, apply SendPolicy = " + sendPolicy.name();
            invLogger.error(errorMessage);
            if (sendPolicy == SendLimitPolicy.Reject) {
                rsfFuture.failed(new RsfException(501, errorMessage));
                return;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            if (this.requestCount.get() >= rsfSettings.getMaximumRequest()) {
                invLogger.error(errorMessage);
                rsfFuture.failed(new RsfException(501, errorMessage));
                return;
            }
        }
        if ((toAddress = rsfRequest.getTargetAddress()) == null) {
            invLogger.warn("request({}) -> targetAddress Unavailable, bindID ={}.", (Object)rsfRequest.getRequestID(), (Object)serviceID);
            rsfFuture.failed(new RsfException(403, "Service [" + serviceID + "] Address Unavailable."));
            return;
        }
        try {
            invLogger.warn("request({}) -> pre sendData, bindID ={}, targetAddress ={}.", new Object[]{rsfRequest.getRequestID(), serviceID, toAddress});
            RsfEnvironment environment = this.getContext().getEnvironment();
            RequestInfo info = ProtocolUtils.buildRequestInfo(environment, rsfRequest);
            info.setFlags(rsfRequest.getFlags());
            this.startRequest(rsfFuture);
            this.sendData(toAddress, info, new SendCallBack(){

                @Override
                public void failed(long requestID, Throwable e) {
                    RsfRequestManager.this.putResponse(requestID, e);
                }

                @Override
                public void complete(long requestID) {
                }
            });
        }
        catch (Throwable e) {
            invLogger.error("request(" + rsfRequest.getRequestID() + ") send error, " + e.getMessage(), e);
            this.putResponse(rsfRequest.getRequestID(), e);
        }
    }

    private void startRequest(RsfFuture rsfFuture) {
        this.requestCount.incrementAndGet();
        this.rsfResponse.put(rsfFuture.getRequest().getRequestID(), rsfFuture);
        RsfRequestFormLocal request = (RsfRequestFormLocal)rsfFuture.getRequest();
        TimerTask timeTask = timeoutObject -> {
            RsfFuture rsfCallBack = this.getRequest(request.getRequestID());
            if (rsfCallBack == null) {
                return;
            }
            String errorInfo = "request(" + request.getRequestID() + ") -> timeout for client.";
            invLogger.error(errorInfo);
            this.putResponse(request.getRequestID(), new RsfTimeoutException(errorInfo));
        };
        invLogger.info("request({}) -> startRequest, timeout at {} ,bindID ={}, callMethod ={}.", new Object[]{request.getRequestID(), request.getTimeout(), request.getBindInfo().getBindID(), request.getMethod()});
        this.getContext().getEnvironment().atTime(timeTask, request.getTimeout());
    }
}

