/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.rpc.caller.remote;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import net.hasor.rsf.InterAddress;
import net.hasor.rsf.RsfContext;
import net.hasor.rsf.RsfEnvironment;
import net.hasor.rsf.RsfSettings;
import net.hasor.rsf.container.RsfBeanContainer;
import net.hasor.rsf.domain.RequestInfo;
import net.hasor.rsf.domain.ResponseInfo;
import net.hasor.rsf.rpc.caller.RsfCaller;
import net.hasor.rsf.rpc.caller.SenderListener;
import net.hasor.rsf.rpc.caller.remote.RemoteRsfCallerProcessing;
import net.hasor.rsf.utils.ExecutesManager;
import net.hasor.rsf.utils.ProtocolUtils;

public class RemoteRsfCaller
extends RsfCaller {
    private final ExecutesManager executesManager;
    private final SenderListener senderListener;

    public RemoteRsfCaller(RsfContext rsfContext, RsfBeanContainer rsfBeanContainer, SenderListener senderListener) {
        super(rsfContext, rsfBeanContainer, senderListener);
        this.senderListener = senderListener;
        RsfSettings rsfSettings = rsfContext.getSettings();
        int queueSize = rsfSettings.getQueueMaxSize();
        int minCorePoolSize = rsfSettings.getQueueMinPoolSize();
        int maxCorePoolSize = rsfSettings.getQueueMaxPoolSize();
        long keepAliveTime = rsfSettings.getQueueKeepAliveTime();
        this.executesManager = new ExecutesManager(minCorePoolSize, maxCorePoolSize, queueSize, keepAliveTime, rsfContext.getClassLoader());
    }

    public void shutdown() {
        logger.info("rsfCaller -> shutdown.");
        this.executesManager.shutdown();
    }

    public void onRequest(InterAddress target, RequestInfo info) {
        RsfEnvironment rsfEnv = this.getContext().getEnvironment();
        String serviceUniqueName = "[" + info.getServiceGroup() + "]" + info.getServiceName() + "-" + info.getServiceVersion();
        try {
            invLogger.info("request({}) -> received, bindID ={}, targetMethod ={}, remoteAddress ={}.", new Object[]{info.getRequestID(), serviceUniqueName, info.getTargetMethod(), target});
            Executor executor = this.executesManager.getExecute(serviceUniqueName);
            executor.execute(new RemoteRsfCallerProcessing(target, this, info));
            ResponseInfo resp = ProtocolUtils.buildResponseStatus(rsfEnv, info.getRequestID(), (short)102, null);
            this.senderListener.sendResponse(target, resp, null);
        }
        catch (RejectedExecutionException e) {
            invLogger.info("request({}) -> rejected request, queue is full. -> bindID ={}, targetMethod ={}, remoteAddress ={}.", new Object[]{info.getRequestID(), serviceUniqueName, info.getTargetMethod(), target});
            String errorMessage = "(" + e.getClass().getName() + ")" + e.getMessage();
            String msgLog = "rejected request, queue is full." + errorMessage;
            logger.warn(msgLog, (Throwable)e);
            ResponseInfo resp = ProtocolUtils.buildResponseStatus(rsfEnv, info.getRequestID(), (short)405, msgLog);
            this.senderListener.sendResponse(target, resp, null);
        }
    }

    SenderListener getSenderListener() {
        return this.senderListener;
    }
}

