/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.rpc.caller.remote;

import java.lang.reflect.Method;
import net.hasor.rsf.InterAddress;
import net.hasor.rsf.RsfBindInfo;
import net.hasor.rsf.RsfContext;
import net.hasor.rsf.RsfRequest;
import net.hasor.rsf.domain.AttributeSet;
import net.hasor.rsf.domain.RequestInfo;
import net.hasor.rsf.domain.RsfFlags;
import net.hasor.rsf.rpc.caller.remote.RemoteRsfCaller;

class RsfRequestFormRemote
extends AttributeSet
implements RsfRequest {
    private final RequestInfo requestInfo;
    private final InterAddress target;
    private final RemoteRsfCaller rsfCaller;
    private final RsfBindInfo<?> bindInfo;
    private final Method targetMethod;
    private final Class<?>[] parameterTypes;
    private final Object[] parameterObjects;

    public RsfRequestFormRemote(InterAddress target, RequestInfo requestInfo, RsfBindInfo<?> bindInfo, Method targetMethod, Object[] parameterObjects, RemoteRsfCaller rsfCaller) {
        this.target = target;
        this.requestInfo = requestInfo;
        this.bindInfo = bindInfo;
        this.targetMethod = targetMethod;
        this.parameterTypes = targetMethod.getParameterTypes();
        this.parameterObjects = parameterObjects;
        this.rsfCaller = rsfCaller;
    }

    public String toString() {
        return "requestID:" + this.getRequestID() + " from Remote," + this.bindInfo.toString();
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public boolean isP2PCalls() {
        return RsfFlags.P2PFlag.testTag(this.requestInfo.getFlags());
    }

    @Override
    public boolean isMessage() {
        return this.requestInfo.isMessage();
    }

    @Override
    public Method getMethod() {
        return this.targetMethod;
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return (Class[])this.parameterTypes.clone();
    }

    @Override
    public Object[] getParameterObject() {
        return (Object[])this.parameterObjects.clone();
    }

    @Override
    public RsfContext getContext() {
        return this.rsfCaller.getContext();
    }

    @Override
    public RsfBindInfo<?> getBindInfo() {
        return this.bindInfo;
    }

    @Override
    public long getRequestID() {
        return this.requestInfo.getRequestID();
    }

    @Override
    public String getSerializeType() {
        return this.requestInfo.getSerializeType();
    }

    @Override
    public long getReceiveTime() {
        return this.requestInfo.getReceiveTime();
    }

    @Override
    public int getTimeout() {
        int timeOut2;
        int timeOut1 = this.requestInfo.getClientTimeout();
        return timeOut1 < (timeOut2 = this.bindInfo.getClientTimeout()) ? timeOut1 : timeOut2;
    }

    @Override
    public String[] getOptionKeys() {
        return this.requestInfo.getOptionKeys();
    }

    @Override
    public String getOption(String key) {
        return this.requestInfo.getOption(key);
    }

    @Override
    public void addOption(String key, String value) {
        this.requestInfo.addOption(key, value);
    }

    @Override
    public void removeOption(String key) {
        this.requestInfo.removeOption(key);
    }

    @Override
    public InterAddress getRemoteAddress() {
        return this.target;
    }

    @Override
    public InterAddress getTargetAddress() {
        String protocol = this.target.getSechma();
        return this.rsfCaller.getContext().bindAddress(protocol);
    }
}

