/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.rpc.client;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import net.hasor.rsf.RsfBindInfo;
import net.hasor.rsf.RsfClient;
import net.hasor.rsf.RsfFuture;
import net.hasor.rsf.RsfResponse;
import net.hasor.rsf.domain.provider.AddressProvider;
import net.hasor.rsf.rpc.caller.RsfCaller;
import net.hasor.utils.future.FutureCallback;

public class RpcRsfClient
implements RsfClient {
    private AddressProvider provider;
    private RsfCaller rsfCaller;

    public RpcRsfClient(AddressProvider provider, RsfCaller rsfCaller) {
        this.provider = provider;
        this.rsfCaller = rsfCaller;
    }

    protected AddressProvider getTargetProvider() {
        return this.provider;
    }

    protected RsfCaller getRsfCaller() {
        return this.rsfCaller;
    }

    @Override
    public <T> T getRemoteByID(String serviceID) {
        return (T)this.getRsfCaller().getRemoteByID(this.getTargetProvider(), serviceID);
    }

    @Override
    public <T> T getRemote(String group, String name, String version) {
        return (T)this.getRsfCaller().getRemote(this.getTargetProvider(), group, name, version);
    }

    @Override
    public <T> T getRemote(RsfBindInfo<T> bindInfo) {
        return this.getRsfCaller().getRemote(this.getTargetProvider(), bindInfo);
    }

    @Override
    public <T> T wrapperByID(String serviceID, Class<T> interFace) {
        return this.getRsfCaller().wrapperByID(this.getTargetProvider(), serviceID, interFace);
    }

    @Override
    public <T> T wrapper(Class<T> interFace) {
        return this.getRsfCaller().wrapper(this.getTargetProvider(), interFace);
    }

    @Override
    public <T> T wrapper(String group, String name, String version, Class<T> interFace) {
        return this.getRsfCaller().wrapper(this.getTargetProvider(), group, name, version, interFace);
    }

    @Override
    public <T> T wrapper(RsfBindInfo<?> bindInfo, Class<T> interFace) {
        return this.getRsfCaller().wrapper(this.getTargetProvider(), bindInfo, interFace);
    }

    @Override
    public Object syncInvoke(RsfBindInfo<?> bindInfo, String methodName, Class<?>[] parameterTypes, Object[] parameterObjects) throws InterruptedException, ExecutionException, TimeoutException {
        return this.getRsfCaller().syncInvoke(this.getTargetProvider(), bindInfo, methodName, parameterTypes, parameterObjects);
    }

    @Override
    public RsfFuture asyncInvoke(RsfBindInfo<?> bindInfo, String methodName, Class<?>[] parameterTypes, Object[] parameterObjects) {
        return this.getRsfCaller().asyncInvoke(this.getTargetProvider(), bindInfo, methodName, parameterTypes, parameterObjects);
    }

    @Override
    public void callBackInvoke(RsfBindInfo<?> bindInfo, String methodName, Class<?>[] parameterTypes, Object[] parameterObjects, FutureCallback<Object> listener) {
        this.getRsfCaller().callBackInvoke(this.getTargetProvider(), bindInfo, methodName, parameterTypes, parameterObjects, listener);
    }

    @Override
    public void callBackRequest(RsfBindInfo<?> bindInfo, String methodName, Class<?>[] parameterTypes, Object[] parameterObjects, FutureCallback<RsfResponse> listener) {
        this.getRsfCaller().callBackRequest(this.getTargetProvider(), bindInfo, methodName, parameterTypes, parameterObjects, listener);
    }
}

