/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.rpc.net;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.hasor.rsf.InterAddress;
import net.hasor.rsf.domain.OptionInfo;
import net.hasor.rsf.domain.RequestInfo;
import net.hasor.rsf.domain.ResponseInfo;
import net.hasor.rsf.domain.RsfException;
import net.hasor.rsf.rpc.net.CloseListener;
import net.hasor.rsf.rpc.net.LinkType;
import net.hasor.rsf.rpc.net.ReceivedListener;
import net.hasor.rsf.rpc.net.SendCallBack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RsfChannel {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String protocol;
    private final InterAddress target;
    private final LinkType linkType;
    private volatile long lastSendTime;
    private volatile long sendPackets;
    private volatile long sendPacketsOk;
    private volatile long sendPacketsErr;
    private List<ReceivedListener> listenerList;
    private CloseListener closeListener;

    public RsfChannel(InterAddress target, LinkType linkType) {
        this.protocol = target.getSechma();
        this.target = target;
        this.linkType = linkType;
        this.listenerList = new CopyOnWriteArrayList<ReceivedListener>();
    }

    public String toString() {
        return "RsfChannel{protocol=" + this.getProtocol() + ", linkType=" + this.linkType.name() + '}';
    }

    public String getProtocol() {
        return this.protocol;
    }

    public final void sendData(RequestInfo info, SendCallBack callBack) {
        this.sendData(info.getRequestID(), info, callBack);
    }

    public final void sendData(ResponseInfo info, SendCallBack callBack) {
        this.sendData(info.getRequestID(), info, callBack);
    }

    private void sendData(long requestID, OptionInfo sendData, final SendCallBack callBack) {
        if (!this.isActive()) {
            RsfException e = new RsfException(600, "send (" + requestID + ") an error, channel is not ready.");
            if (callBack != null) {
                callBack.failed(requestID, e);
            }
            return;
        }
        ++this.sendPackets;
        this.lastSendTime = System.currentTimeMillis();
        this.sendData(sendData, new SendCallBack(){
            private boolean asked = false;

            @Override
            public void failed(long requestID, Throwable ex) {
                if (this.asked) {
                    return;
                }
                RsfChannel.this.sendPacketsErr++;
                if (callBack != null) {
                    callBack.failed(requestID, new RsfException(600, ex.getMessage(), ex));
                }
                this.asked = true;
            }

            @Override
            public void complete(long requestID) {
                if (this.asked) {
                    return;
                }
                RsfChannel.this.sendPacketsOk++;
                if (callBack != null) {
                    callBack.complete(requestID);
                }
                this.asked = true;
            }
        });
    }

    final void receivedData(OptionInfo object) {
        if (!this.isActive()) {
            return;
        }
        for (ReceivedListener listener : this.listenerList) {
            listener.receivedMessage(this, object);
        }
    }

    final void addListener(ReceivedListener receivedListener) {
        if (!this.listenerList.contains(receivedListener)) {
            this.listenerList.add(receivedListener);
        }
    }

    public LinkType getLinkType() {
        return this.linkType;
    }

    public long getLastSendTime() {
        return this.lastSendTime;
    }

    public long getSendPackets() {
        return this.sendPackets;
    }

    public long getSendPacketsOk() {
        return this.sendPacketsOk;
    }

    public long getSendPacketsErr() {
        return this.sendPacketsErr;
    }

    public abstract boolean isActive();

    public InterAddress getTarget() {
        if (this.target != null) {
            return this.target;
        }
        return null;
    }

    public void close() {
        if (this.isActive()) {
            if (this.closeListener != null) {
                this.closeListener.doClose(this);
            }
            this.closeChannel();
        }
    }

    void onClose(CloseListener closeListener) {
        this.closeListener = closeListener;
    }

    protected boolean equalsSameAs(RsfChannel rsfChannel) {
        return this.target.getHostPort().equals(rsfChannel.target.getHostPort());
    }

    protected abstract void closeChannel();

    protected abstract void sendData(OptionInfo var1, SendCallBack var2);
}

