/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.rpc.net;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.hasor.core.AppContext;
import net.hasor.rsf.RsfEnvironment;
import net.hasor.rsf.RsfSettings;
import net.hasor.rsf.rpc.net.Connector;
import net.hasor.rsf.rpc.net.ConnectorFactory;
import net.hasor.rsf.rpc.net.ReceivedAdapter;
import net.hasor.rsf.rpc.net.RsfChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RsfNetManager {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RsfEnvironment rsfEnvironment;
    private final ReceivedAdapter receivedAdapter;
    private final Map<String, Connector> protocolConnector = new HashMap<String, Connector>();
    private final Map<String, List<String>> sechmaMapping = new HashMap<String, List<String>>();

    public RsfNetManager(RsfEnvironment rsfEnvironment, ReceivedAdapter receivedAdapter) {
        this.rsfEnvironment = rsfEnvironment;
        this.receivedAdapter = receivedAdapter;
    }

    public RsfEnvironment getRsfEnvironment() {
        return this.rsfEnvironment;
    }

    public Set<String> runProtocols() {
        return Collections.unmodifiableSet(this.protocolConnector.keySet());
    }

    public Connector findConnector(String protocol) {
        return this.protocolConnector.get(protocol);
    }

    public Connector findConnectorBySechma(String sechma) {
        if (!this.sechmaMapping.containsKey(sechma)) {
            return null;
        }
        List<String> protocolNames = this.sechmaMapping.get(sechma);
        return this.findConnector(protocolNames.get(0));
    }

    public void start(AppContext appContext) {
        RsfSettings settings = this.getRsfEnvironment().getSettings();
        String defaultProtocol = settings.getDefaultProtocol();
        Set<String> protocolSet = settings.getProtocos();
        for (String protocol : protocolSet) {
            String configKey = settings.getProtocolConfigKey(protocol);
            String sechmaName = settings.getString(configKey + ".protocol");
            List<String> sechmaMapping = this.sechmaMapping.get(sechmaName);
            if (sechmaMapping == null) {
                sechmaMapping = new ArrayList<String>();
                this.sechmaMapping.put(sechmaName, sechmaMapping);
            }
            if (sechmaMapping.contains(protocol)) {
                this.logger.error("connector[{}] failed -> repeat.", (Object)protocol);
                if (defaultProtocol.equals(protocol)) {
                    throw new IllegalStateException("default connector start failed. " + protocol + "-> repeat protocol.");
                }
            }
            try {
                String connectorFactory = settings.getString(configKey + ".factory");
                Class<?> factoryClass = appContext.getClassLoader().loadClass(connectorFactory);
                ConnectorFactory factory = (ConnectorFactory)appContext.getInstance(factoryClass);
                Connector connector = factory.create(protocol, appContext, this.receivedAdapter, this::acceptChannel);
                if (connector == null) {
                    this.logger.info("connector[{}] disable, connector is null.", (Object)protocol);
                    continue;
                }
                connector.startListener(appContext);
                sechmaMapping.add(protocol);
                this.protocolConnector.put(protocol, connector);
            }
            catch (Throwable e) {
                this.logger.error("connector[{}] failed -> {}", new Object[]{protocol, e.getMessage(), e});
                throw new IllegalStateException("connector " + protocol + " start failed.", e);
            }
        }
        if (this.findConnector(defaultProtocol) == null) {
            try {
                this.logger.error("start failed , default {} protocol failed", (Object)defaultProtocol);
                throw new IllegalStateException("start failed , default " + defaultProtocol + " protocol failed");
            }
            catch (Throwable throwable) {
                this.shutdown();
                throw throwable;
            }
        }
    }

    protected boolean acceptChannel(RsfChannel rsfChannel) throws IOException {
        return true;
    }

    public void shutdown() {
        this.logger.info("rsfNetManager, shutdownGracefully.");
        if (!this.protocolConnector.isEmpty()) {
            for (Connector listener : this.protocolConnector.values()) {
                listener.shutdown();
            }
            this.protocolConnector.clear();
            this.sechmaMapping.clear();
        }
    }
}

