/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.rpc.net.netty;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.concurrent.ThreadFactory;
import net.hasor.rsf.RsfEnvironment;
import net.hasor.rsf.RsfSettings;
import net.hasor.utils.NameThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NettyThreadGroup {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private EventLoopGroup workLoopGroup;
    private NioEventLoopGroup listenLoopGroup;

    NettyThreadGroup(String protocol, RsfEnvironment rsfEnvironment) {
        RsfSettings rsfSettings = rsfEnvironment.getSettings();
        String configKey = rsfSettings.getProtocolConfigKey(protocol);
        int workerThread = rsfSettings.getInteger(configKey + ".workerThread", 8);
        int listenerThread = rsfSettings.getInteger(configKey + ".listenThread", 1);
        String preName = "RSF(" + protocol + ")";
        this.logger.info("nioEventLoopGroup, workerThread = {} , listenerThread = {}", (Object)workerThread, (Object)listenerThread);
        this.workLoopGroup = new NioEventLoopGroup(workerThread, (ThreadFactory)new NameThreadFactory(preName + "-Nio-%s", rsfEnvironment.getClassLoader()));
        this.listenLoopGroup = new NioEventLoopGroup(listenerThread, (ThreadFactory)new NameThreadFactory(preName + "-Listen-%s", rsfEnvironment.getClassLoader()));
    }

    public void shutdownGracefully() {
        this.logger.info("shutdownGracefully -> nioEventLoopGroup (listenLoopGroup and workLoopGroup).");
        this.listenLoopGroup.shutdownGracefully();
        this.workLoopGroup.shutdownGracefully();
    }

    public EventLoopGroup getWorkLoopGroup() {
        return this.workLoopGroup;
    }

    public NioEventLoopGroup getListenLoopGroup() {
        return this.listenLoopGroup;
    }
}

