/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.tconsole;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.hasor.core.Inject;
import net.hasor.core.Singleton;
import net.hasor.rsf.InterAddress;
import net.hasor.rsf.RsfBindInfo;
import net.hasor.rsf.RsfContext;
import net.hasor.rsf.RsfSettings;
import net.hasor.rsf.domain.RsfServiceType;
import net.hasor.tconsole.TelCommand;
import net.hasor.tconsole.TelExecutor;

@Singleton
public class InfoRsfInstruct
implements TelExecutor {
    @Inject
    private RsfContext rsfContext;

    public String helpInfo() {
        return "show server info.\r\n - info -h   (show help info.)\r\n - info      (show server info.)";
    }

    public String doCommand(TelCommand telCommand) throws Throwable {
        String doArg;
        StringWriter sw = new StringWriter();
        String[] args = telCommand.getCommandArgs();
        if (args != null && args.length > 0 && "-h".equalsIgnoreCase(doArg = args[0])) {
            sw.write(this.helpInfo());
            return sw.toString();
        }
        Set<String> protocolSet = this.rsfContext.getSettings().getProtocos();
        HashMap<String, InterAddress> bindAddressSet = new HashMap<String, InterAddress>();
        for (String protocol : protocolSet) {
            InterAddress interAddress = this.rsfContext.bindAddress(protocol);
            if (interAddress == null) continue;
            bindAddressSet.put(protocol, interAddress);
        }
        ArrayList arrays = new ArrayList(bindAddressSet.keySet());
        Collections.sort(arrays);
        RsfSettings settings = this.rsfContext.getSettings();
        int providerCount = 0;
        int customerCount = 0;
        List<String> serviceIDs = this.rsfContext.getServiceIDs();
        for (String sid : serviceIDs) {
            RsfBindInfo serviceInfo = this.rsfContext.getServiceInfo(sid);
            if (serviceInfo.getServiceType() == RsfServiceType.Provider) {
                ++providerCount;
                continue;
            }
            if (serviceInfo.getServiceType() != RsfServiceType.Consumer) continue;
            ++customerCount;
        }
        sw.write(">>\r\n");
        sw.write(">>----- Server Info ------\r\n");
        sw.write(">>        bindAddress : [\r\n");
        for (String key : arrays) {
            InterAddress interAddress = (InterAddress)bindAddressSet.get(key);
            sw.write(">>            bindAddress :(" + key + ")" + interAddress.toHostSchema() + "\r\n");
        }
        sw.write(">> ]\r\n");
        sw.write(">>           isOnline :" + this.rsfContext.isOnline() + "\r\n");
        sw.write(">>    automaticOnline :" + settings.isAutomaticOnline() + "\r\n");
        sw.write(">>      service Count :" + serviceIDs.size() + "\r\n");
        sw.write(">>     provider Count :" + providerCount + "\r\n");
        sw.write(">>     customer Count :" + customerCount + "\r\n");
        sw.write(">>\r\n");
        sw.write(">>----- Default Info ------\r\n");
        sw.write(">>            timeout :" + settings.getDefaultTimeout() + "\r\n");
        sw.write(">>              group :" + settings.getDefaultGroup() + "\r\n");
        sw.write(">>            version :" + settings.getDefaultVersion() + "\r\n");
        sw.write(">>      serializeType :" + settings.getDefaultSerializeType() + "\r\n");
        sw.write(">>\r\n");
        sw.write(">>----- Network Settings ------\r\n");
        sw.write(">>     connectTimeout :" + settings.getConnectTimeout() + "\r\n");
        sw.write(">>\r\n");
        sw.write(">>----- RPC Settings ------\r\n");
        sw.write(">>       queueMaxSize :" + settings.getQueueMaxSize() + "\r\n");
        sw.write(">>   queueMinPoolSize :" + settings.getQueueMinPoolSize() + "\r\n");
        sw.write(">>   queueMaxPoolSize :" + settings.getQueueMaxPoolSize() + "\r\n");
        sw.write(">> queueKeepAliveTime :" + settings.getQueueKeepAliveTime() + "\r\n");
        sw.write(">>     requestTimeout :" + settings.getRequestTimeout() + "\r\n");
        sw.write(">>     maximumRequest :" + settings.getMaximumRequest() + "\r\n");
        sw.write(">>    sendLimitPolicy :" + settings.getSendLimitPolicy().name() + "\r\n");
        sw.write(">>\r\n");
        sw.write(">>----- Address Policy------\r\n");
        sw.write(">>       invalidWaitTime :" + settings.getInvalidWaitTime() + "\r\n");
        sw.write(">>      refreshCacheTime :" + settings.getRefreshCacheTime() + "\r\n");
        sw.write(">>        localDiskCache :" + settings.islocalDiskCache() + "\r\n");
        sw.write(">> diskCacheTimeInterval :" + settings.getDiskCacheTimeInterval() + "\r\n");
        return sw.toString();
    }
}

