/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.tconsole;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import net.hasor.core.Inject;
import net.hasor.core.Singleton;
import net.hasor.rsf.RsfContext;
import net.hasor.tconsole.TelCommand;
import net.hasor.tconsole.TelExecutor;
import net.hasor.tconsole.TelReader;
import net.hasor.utils.StringUtils;

@Singleton
public class RuleRsfInstruct
implements TelExecutor {
    @Inject
    private RsfContext rsfContext;

    public String helpInfo() {
        return "service rule script show/update.\r\n - rule              (show help info.)\r\n - rule -s XXXX      (show service Level rule info of XXXX.)\r\n - rule -m XXXX      (show method Level rule info of XXXX.)\r\n - rule -a XXXX      (show args Level rule info of XXXX.)\r\n - rule -us XXXX     (update service Level rule info of XXXX.)\r\n - rule -um XXXX     (update method Level rule info of XXXX.)\r\n - rule -ua XXXX     (update args Level rule info of XXXX.)\r\n - rule -cs XXXX     (clean service Level rule info of XXXX.)\r\n - rule -cm XXXX     (clean method Level rule info of XXXX.)\r\n - rule -ca XXXX     (clean args Level rule info of XXXX.)";
    }

    public boolean readCommand(TelCommand telCommand, TelReader telReader) {
        String[] args = telCommand.getCommandArgs();
        if (args != null && args.length > 0 && args[0].startsWith("-u")) {
            return telReader.expectDoubleBlankLines();
        }
        return true;
    }

    public String doCommand(TelCommand telCommand) throws Throwable {
        StringWriter sw = new StringWriter();
        String[] args = telCommand.getCommandArgs();
        if (args != null && args.length > 1) {
            String scriptBody;
            String mode = args[0];
            String nameArg = args[1];
            if (mode != null && mode.startsWith("-u") && StringUtils.isBlank((String)(scriptBody = telCommand.getCommandBody()))) {
                return "[ERROR] updated content is empty, ignore.";
            }
            if ("-s".equalsIgnoreCase(mode)) {
                this.showServiceRule(sw, nameArg, this.rsfContext);
            } else if ("-m".equalsIgnoreCase(mode)) {
                this.showMethodRule(sw, nameArg, this.rsfContext);
            } else if ("-a".equalsIgnoreCase(mode)) {
                this.showArgsRule(sw, nameArg, this.rsfContext);
            } else if ("-us".equalsIgnoreCase(mode)) {
                this.updateServiceRule(sw, nameArg, telCommand, this.rsfContext);
            } else if ("-um".equalsIgnoreCase(mode)) {
                this.updateMethodRule(sw, nameArg, telCommand, this.rsfContext);
            } else if ("-ua".equalsIgnoreCase(mode)) {
                this.updateArgsRule(sw, nameArg, telCommand, this.rsfContext);
            } else if ("-cs".equalsIgnoreCase(mode)) {
                this.cleanServiceRule(sw, nameArg, telCommand, this.rsfContext);
            } else if ("-cm".equalsIgnoreCase(mode)) {
                this.cleanMethodRule(sw, nameArg, telCommand, this.rsfContext);
            } else if ("-ca".equalsIgnoreCase(mode)) {
                this.cleanArgsRule(sw, nameArg, telCommand, this.rsfContext);
            } else {
                sw.write("[ERROR] bad args.");
            }
        } else {
            sw.write(">>>>>>>>>>>>>>>>>>>>>>>>  rule  <<<<<<<<<<<<<<<<<<<<<<<<\r\n");
            sw.write(this.helpInfo());
        }
        return sw.toString();
    }

    private void showArgsRule(StringWriter sw, String nameArg, RsfContext rsfContext) throws IOException {
        String body = rsfContext.getUpdater().argsRoute(nameArg);
        if (StringUtils.isBlank((String)body)) {
            sw.write("[SUCCEED] content is empty.");
        } else {
            this.writeBody(sw, body);
        }
    }

    private void showMethodRule(StringWriter sw, String nameArg, RsfContext rsfContext) throws IOException {
        String body = rsfContext.getUpdater().methodRoute(nameArg);
        if (StringUtils.isBlank((String)body)) {
            sw.write("[SUCCEED] content is empty.");
        } else {
            this.writeBody(sw, body);
        }
    }

    private void showServiceRule(StringWriter sw, String nameArg, RsfContext rsfContext) throws IOException {
        String body = rsfContext.getUpdater().serviceRoute(nameArg);
        if (StringUtils.isBlank((String)body)) {
            sw.write("[SUCCEED] content is empty.");
        } else {
            this.writeBody(sw, body);
        }
    }

    private void writeBody(StringWriter sw, String body) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new StringReader(body));
        while ((line = reader.readLine()) != null) {
            sw.write(line + "\r\n");
        }
    }

    private void updateArgsRule(StringWriter sw, String nameArg, TelCommand telCommand, RsfContext rsfContext) {
        String scriptBody = telCommand.getCommandBody();
        if (rsfContext.getServiceInfo(nameArg) == null) {
            sw.write("[ERROR] serviceID is not exist.");
            return;
        }
        boolean result = rsfContext.getUpdater().updateArgsRoute(nameArg, scriptBody);
        sw.write("[" + (result ? "SUCCEED" : "FAILED") + "] update ArgsLevel route script of serviceID = " + nameArg);
    }

    private void updateMethodRule(StringWriter sw, String nameArg, TelCommand telCommand, RsfContext rsfContext) {
        String scriptBody = telCommand.getCommandBody();
        if (rsfContext.getServiceInfo(nameArg) == null) {
            sw.write("[ERROR] serviceID is not exist.");
            return;
        }
        boolean result = rsfContext.getUpdater().updateMethodRoute(nameArg, scriptBody);
        sw.write("[" + (result ? "SUCCEED" : "FAILED") + "] update MethodLevel route script of serviceID = " + nameArg);
    }

    private void updateServiceRule(StringWriter sw, String nameArg, TelCommand telCommand, RsfContext rsfContext) {
        String scriptBody = telCommand.getCommandBody();
        if (rsfContext.getServiceInfo(nameArg) == null) {
            sw.write("[ERROR] serviceID is not exist.");
            return;
        }
        boolean result = rsfContext.getUpdater().updateServiceRoute(nameArg, scriptBody);
        sw.write("[" + (result ? "SUCCEED" : "FAILED") + "] update ServiceLevel route script of serviceID = " + nameArg);
    }

    private void cleanArgsRule(StringWriter sw, String nameArg, TelCommand telCommand, RsfContext rsfContext) {
        if (rsfContext.getServiceInfo(nameArg) == null) {
            sw.write("[ERROR] serviceID is not exist.");
            return;
        }
        boolean result = rsfContext.getUpdater().updateArgsRoute(nameArg, null);
        sw.write("[" + (result ? "SUCCEED" : "FAILED") + "] clean ArgsLevel route script of serviceID = " + nameArg);
    }

    private void cleanMethodRule(StringWriter sw, String nameArg, TelCommand telCommand, RsfContext rsfContext) {
        if (rsfContext.getServiceInfo(nameArg) == null) {
            sw.write("[ERROR] serviceID is not exist.");
            return;
        }
        boolean result = rsfContext.getUpdater().updateMethodRoute(nameArg, null);
        sw.write("[" + (result ? "SUCCEED" : "FAILED") + "] clean MethodLevel route script of serviceID = " + nameArg);
    }

    private void cleanServiceRule(StringWriter sw, String nameArg, TelCommand telCommand, RsfContext rsfContext) {
        if (rsfContext.getServiceInfo(nameArg) == null) {
            sw.write("[ERROR] serviceID is not exist.");
            return;
        }
        boolean result = rsfContext.getUpdater().updateServiceRoute(nameArg, null);
        sw.write("[" + (result ? "SUCCEED" : "FAILED") + "] clean ArgsLevel route script of serviceID = " + nameArg);
    }
}

