/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.utils;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkUtils {
    protected static Logger logger = LoggerFactory.getLogger(NetworkUtils.class);

    private static void isPortAvailable(String host, int port) throws Exception {
        Socket s = new Socket();
        s.bind(new InetSocketAddress(host, port));
        s.close();
    }

    public static boolean isPortAvailable(int port) {
        try {
            NetworkUtils.isPortAvailable("0.0.0.0", port);
            NetworkUtils.isPortAvailable(InetAddress.getLocalHost().getHostAddress(), port);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static byte[] ipStrToBytes(String ipData) {
        byte[] ipParts = new byte[4];
        String[] splitArrays = ipData.split("\\.");
        for (int i = 0; i < splitArrays.length; ++i) {
            ipParts[i] = (byte)Integer.parseInt(splitArrays[i]);
        }
        return ipParts;
    }

    public static InetAddress finalBindAddress(String hostString) throws UnknownHostException {
        if ("local".equalsIgnoreCase(hostString)) {
            List<String> localAddr = NetworkUtils.localIpAddr();
            if (localAddr.isEmpty()) {
                return InetAddress.getLocalHost();
            }
            return InetAddress.getByName(localAddr.get(0));
        }
        return InetAddress.getByName(hostString);
    }

    public static String maskToStringByPrefixLength(int length) {
        return NetworkUtils.ipDataToString(NetworkUtils.ipDataByInt(NetworkUtils.maskByPrefixLength(length)));
    }

    public static int maskByPrefixLength(int length) {
        if (length > 32) {
            throw new IndexOutOfBoundsException("mask length max is 32.");
        }
        return -1 << 32 - length;
    }

    public static byte[] ipDataByInt(int ipData) {
        byte[] ipParts = new byte[4];
        for (int i = 0; i < ipParts.length; ++i) {
            int pos = ipParts.length - 1 - i;
            ipParts[pos] = (byte)(ipData >> i * 8);
        }
        return ipParts;
    }

    public static int ipDataByBytes(byte[] ipData) {
        int[] ipParts = new int[]{0xFFFFFFFF & ipData[0] << 24, 0xFFFFFF & ipData[1] << 16, 0xFFFF & ipData[2] << 8, 0xFF & ipData[3] << 0};
        int intIP = 0;
        for (int i = 0; i < ipParts.length; ++i) {
            intIP |= ipParts[i];
        }
        return intIP;
    }

    public static String ipDataToString(int ipData) {
        return NetworkUtils.ipDataToString(NetworkUtils.ipDataByInt(ipData));
    }

    public static String ipDataToString(byte[] ipData) {
        String result = "";
        result = result + NetworkUtils.tostr(ipData[0]);
        for (int i = 1; i < ipData.length; ++i) {
            result = result + "." + NetworkUtils.tostr(ipData[i]);
        }
        return result;
    }

    private static String tostr(byte byteData) {
        return "" + (byteData < 0 ? 256 + byteData : byteData);
    }

    public static List<String> localIpAddr() {
        ArrayList<String> ipList = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                Enumeration<InetAddress> ipAddrEnum = ni.getInetAddresses();
                while (ipAddrEnum.hasMoreElements()) {
                    String ip;
                    InetAddress addr = ipAddrEnum.nextElement();
                    if (addr.isLoopbackAddress() || (ip = addr.getHostAddress()).contains(":")) continue;
                    logger.debug("Interface: " + ni.getName() + ", IP: " + ip);
                    ipList.add(ip);
                }
            }
            Collections.sort(ipList);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Failed to get local ip list. " + e.getMessage());
            throw new RuntimeException("Failed to get local ip list");
        }
        return ipList;
    }

    public static void localIpAddr(Set<String> set) {
        List<String> addrList = NetworkUtils.localIpAddr();
        set.clear();
        set.addAll(addrList);
    }
}

