/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.utils;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.io.IOException;
import net.hasor.rsf.RsfBindInfo;
import net.hasor.rsf.RsfEnvironment;
import net.hasor.rsf.RsfRequest;
import net.hasor.rsf.RsfResponse;
import net.hasor.rsf.domain.RequestInfo;
import net.hasor.rsf.domain.ResponseInfo;
import net.hasor.rsf.domain.RsfRuntimeUtils;
import net.hasor.utils.StringUtils;

public class ProtocolUtils {
    public static RequestInfo buildRequestInfo(RsfEnvironment env, RsfRequest rsfRequest) throws IOException {
        RequestInfo info = new RequestInfo();
        RsfBindInfo<?> rsfBindInfo = rsfRequest.getBindInfo();
        String serializeType = rsfRequest.getSerializeType();
        info.setRequestID(rsfRequest.getRequestID());
        info.setServiceGroup(rsfBindInfo.getBindGroup());
        info.setServiceName(rsfBindInfo.getBindName());
        info.setServiceVersion(rsfBindInfo.getBindVersion());
        info.setTargetMethod(rsfRequest.getMethod().getName());
        info.setSerializeType(serializeType);
        info.setClientTimeout(rsfRequest.getTimeout());
        info.setMessage(rsfRequest.isMessage());
        Class<?>[] pTypes = rsfRequest.getParameterTypes();
        Object[] pObjects = rsfRequest.getParameterObject();
        pTypes = pTypes == null ? new Class[]{} : pTypes;
        pObjects = pObjects == null ? new Object[]{} : pObjects;
        for (int i = 0; i < pTypes.length; ++i) {
            String typeByte = RsfRuntimeUtils.toAsmType(pTypes[i]);
            info.addParameter(typeByte, pObjects[i]);
        }
        info.addOptionMap(rsfRequest);
        return info;
    }

    public static ResponseInfo buildResponseStatus(RsfEnvironment env, long requestID, short status, String errorInfo) {
        ResponseInfo info = new ResponseInfo();
        info.setRequestID(requestID);
        info.setStatus(status);
        if (StringUtils.isNotBlank((String)errorInfo)) {
            info.addOption("message", errorInfo);
        }
        return info;
    }

    public static ResponseInfo buildResponseInfo(RsfEnvironment env, RsfResponse rsfResponse) throws IOException {
        ResponseInfo info = new ResponseInfo();
        String serializeType = rsfResponse.getSerializeType();
        info.setRequestID(rsfResponse.getRequestID());
        info.setStatus(rsfResponse.getStatus());
        info.setSerializeType(serializeType);
        info.setReturnType(rsfResponse.getReturnType().getName());
        info.setReturnData(rsfResponse.getData());
        info.addOptionMap(rsfResponse);
        return info;
    }

    public static ByteBuf newByteBuf() {
        return PooledByteBufAllocator.DEFAULT.directBuffer();
    }
}

