/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.spring.beans;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.hasor.core.AppContext;
import net.hasor.spring.beans.RuntimeFilter2Controller;
import net.hasor.utils.StringUtils;
import net.hasor.web.binder.OneConfig;
import net.hasor.web.startup.RuntimeFilter;
import net.hasor.web.startup.RuntimeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class SpringHasorDispatcher
implements InitializingBean,
ApplicationContextAware {
    protected static Logger logger = LoggerFactory.getLogger(SpringHasorDispatcher.class);
    private ApplicationContext applicationContext;
    private List<String> mappingPath = new ArrayList<String>();

    public List<String> getMappingPath() {
        return this.mappingPath;
    }

    public void setMappingPath(List<String> mappingPath) {
        this.mappingPath = mappingPath;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        Object[] mappingPaths = SpringHasorDispatcher.evalFilterPath(this.mappingPath.toArray(new String[0]));
        logger.info("spring hasor web-dispatcher mappingPath -> " + StringUtils.join((Object[])mappingPaths, (String)","));
        ServletContext contextBean = (ServletContext)this.applicationContext.getBean(ServletContext.class);
        AppContext appContext = RuntimeListener.getAppContext((ServletContext)contextBean);
        RuntimeFilter runtimeFilter = new RuntimeFilter(appContext);
        runtimeFilter.init((FilterConfig)new OneConfig("", () -> appContext));
        RequestMappingHandlerMapping requestMappingHandlerMapping = (RequestMappingHandlerMapping)this.applicationContext.getBean(RequestMappingHandlerMapping.class);
        RuntimeFilter2Controller handler = new RuntimeFilter2Controller(runtimeFilter, appContext);
        Method handlerMethod = RuntimeFilter2Controller.class.getMethod("doHandler", HttpServletRequest.class, HttpServletResponse.class);
        RequestMappingInfo info = RequestMappingInfo.paths((String[])mappingPaths).methods(RequestMethod.values()).build();
        requestMappingHandlerMapping.registerMapping(info, (Object)handler, handlerMethod);
    }

    private static String[] evalFilterPath(String[] filterPath) {
        String[] filterPathArray = new String[filterPath.length];
        for (int i = 0; i < filterPath.length; ++i) {
            String tmp = filterPath[i];
            if (tmp.endsWith("/*")) {
                tmp = tmp.substring(0, tmp.length() - 2) + "/**";
            }
            filterPathArray[i] = tmp;
        }
        return filterPathArray;
    }
}

