/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.spring.beans;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Predicate;
import javax.servlet.ServletContext;
import net.hasor.core.ApiBinder;
import net.hasor.core.AppContext;
import net.hasor.core.Hasor;
import net.hasor.core.Module;
import net.hasor.core.exts.aop.Matchers;
import net.hasor.spring.beans.AbstractEnvironmentAware;
import net.hasor.spring.beans.AutoScanPackagesModule;
import net.hasor.spring.beans.BuildConfig;
import net.hasor.utils.ResourcesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.web.context.WebApplicationContext;

public class ContextFactoryBean
extends AbstractEnvironmentAware
implements FactoryBean<Object>,
InitializingBean,
DisposableBean,
Module,
ApplicationContextAware,
EnvironmentAware {
    protected static Logger logger = LoggerFactory.getLogger(Hasor.class);
    private AppContext realAppContext = null;
    private ApplicationContext applicationContext = null;
    private String[] loadModules = null;
    private String[] scanPackages = null;
    private final BuildConfig buildConfig = new BuildConfig();

    public void setMainConfig(String mainConfig) {
        this.buildConfig.mainConfig = mainConfig;
    }

    public void setRefProperties(Properties refProperties) {
        this.buildConfig.refProperties = refProperties;
    }

    public void setUseProperties(boolean useProperties) {
        this.buildConfig.useProperties = useProperties;
    }

    public void setCustomProperties(Map<Object, Object> customProperties) {
        if (this.buildConfig.customProperties == null) {
            this.buildConfig.customProperties = new HashMap<Object, Object>();
        }
        this.buildConfig.customProperties.putAll(customProperties);
    }

    public void setLoadModules(String[] loadModules) {
        this.loadModules = loadModules;
    }

    public void setScanPackages(String[] scanPackages) {
        this.scanPackages = scanPackages;
    }

    public final void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setEnvironment(Environment environment) {
        this.buildConfig.envProperties = super.setupEnvironment(environment);
    }

    public final Object getObject() throws Exception {
        return this.realAppContext;
    }

    public final Class<?> getObjectType() {
        return AppContext.class;
    }

    public final boolean isSingleton() {
        return true;
    }

    public final void afterPropertiesSet() throws Exception {
        ServletContext parentObject = null;
        if (ResourcesUtils.getResourceAsStream((String)"/org/springframework/web/context/WebApplicationContext.class") != null && this.applicationContext instanceof WebApplicationContext) {
            parentObject = ((WebApplicationContext)this.applicationContext).getServletContext();
        }
        HashSet<Class> needCheckRepeat = new HashSet<Class>();
        if (this.loadModules != null) {
            for (String name : this.loadModules) {
                needCheckRepeat.add(this.applicationContext.getType(name));
                this.buildConfig.loadModules.add((Module)this.applicationContext.getBean(name));
            }
        }
        if (this.scanPackages != null && this.scanPackages.length > 0) {
            Predicate classPredicate = needCheckRepeat.isEmpty() ? Matchers.anyClass() : Matchers.anyClassExcludes(needCheckRepeat);
            AutoScanPackagesModule autoScanModule = new AutoScanPackagesModule(this.scanPackages, classPredicate);
            autoScanModule.setApplicationContext(Objects.requireNonNull(this.applicationContext));
            this.buildConfig.loadModules.add(autoScanModule);
        }
        this.realAppContext = this.buildConfig.build(parentObject, this.applicationContext).build(new Module[]{this});
        logger.info("hasor Spring factory inited.");
    }

    public void loadModule(ApiBinder apiBinder) {
        apiBinder.bindType(ApplicationContext.class).toInstance((Object)this.applicationContext);
    }

    public final void destroy() {
        if (this.realAppContext != null) {
            this.realAppContext.shutdown();
        }
    }
}

