/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.spring.beans;

import java.util.Objects;
import java.util.function.Supplier;
import net.hasor.core.AppContext;
import net.hasor.core.BindInfo;
import net.hasor.utils.StringUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class TargetFactoryBean<T>
implements FactoryBean<T>,
InitializingBean {
    private AppContext factory = null;
    private Supplier<? extends T> beanProvider = null;
    private BindInfo<? extends T> beanBindInfo = null;
    private String refID = null;
    private Class<? extends T> refType = null;
    private String refName = null;

    public void setFactory(AppContext factory) {
        this.factory = factory;
    }

    public void setRefType(Class<? extends T> refType) {
        this.refType = refType;
    }

    public void setRefName(String refName) {
        this.refName = refName;
    }

    public void setRefID(String refID) {
        this.refID = refID;
    }

    public void afterPropertiesSet() {
        if (this.factory == null) {
            throw new NullPointerException("AppContext is null.");
        }
        if (StringUtils.isNotBlank((String)this.refID)) {
            this.beanBindInfo = this.factory.getBindInfo(this.refID);
        } else if (this.refType != null) {
            if (StringUtils.isBlank((String)this.refName)) {
                this.refName = "";
            }
            this.beanBindInfo = this.factory.findBindingRegister(this.refName, this.refType);
        } else {
            throw new NullPointerException("refType is null.");
        }
        this.beanProvider = this.beanBindInfo == null ? Objects.requireNonNull(this.factory.getProvider(this.refType)) : Objects.requireNonNull(this.factory.getProvider(this.beanBindInfo));
    }

    public final T getObject() {
        return this.beanProvider.get();
    }

    public final Class<?> getObjectType() {
        return this.beanBindInfo.getBindType();
    }

    public final boolean isSingleton() {
        return this.factory.isSingleton(this.beanBindInfo);
    }
}

