/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.spring.boot;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.servlet.ServletContext;
import net.hasor.core.AppContext;
import net.hasor.core.DimModule;
import net.hasor.core.Module;
import net.hasor.core.exts.aop.Matchers;
import net.hasor.spring.beans.AbstractTypeSupplierTools;
import net.hasor.spring.beans.AutoScanPackagesModule;
import net.hasor.spring.beans.BuildConfig;
import net.hasor.spring.boot.EnableHasor;
import net.hasor.spring.boot.Property;
import net.hasor.utils.ExceptionUtils;
import net.hasor.utils.ResourcesUtils;
import net.hasor.utils.StringUtils;
import net.hasor.utils.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnNotWebApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

@Configuration(proxyBeanMethods=false)
public class BasicHasorConfiguration
extends AbstractTypeSupplierTools
implements ImportAware {
    private static final Logger logger = LoggerFactory.getLogger(BasicHasorConfiguration.class);

    public final void setImportMetadata(AnnotationMetadata importMetadata) {
        Property[] customProperties;
        BuildConfig buildConfig = this.getBuildConfig();
        ApplicationContext applicationContext = this.getApplicationContext();
        Set types = importMetadata.getAnnotationTypes();
        if (!types.contains(EnableHasor.class.getName())) {
            return;
        }
        EnableHasor enableHasor = null;
        try {
            String className = importMetadata.getClassName();
            ClassLoader classLoader = applicationContext.getClassLoader();
            if (classLoader == null) {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            Class<?> loadClass = classLoader.loadClass(className);
            enableHasor = loadClass.getAnnotation(EnableHasor.class);
        }
        catch (ClassNotFoundException e) {
            throw ExceptionUtils.toRuntimeException((Throwable)e);
        }
        buildConfig.mainConfig = enableHasor.mainConfig();
        buildConfig.useProperties = enableHasor.useProperties();
        for (Class<? extends Module> startWith : enableHasor.startWith()) {
            Annotation[] interfaces;
            boolean useSpring = false;
            for (Annotation annotatedType : interfaces = startWith.getAnnotations()) {
                if (annotatedType instanceof Component) {
                    useSpring = true;
                    break;
                }
                if (annotatedType.annotationType().getAnnotation(Component.class) == null) continue;
                useSpring = true;
                break;
            }
            if (useSpring) {
                buildConfig.loadModules.add((Module)applicationContext.getBean(startWith));
                continue;
            }
            try {
                buildConfig.loadModules.add(startWith.newInstance());
            }
            catch (Exception e) {
                throw ExceptionUtils.toRuntimeException((Throwable)e);
            }
        }
        HashSet<Class<? extends Module>> needCheckRepeat = new HashSet<Class<? extends Module>>(Arrays.asList(enableHasor.startWith()));
        for (String name : applicationContext.getBeanDefinitionNames()) {
            Class type = applicationContext.getType(name);
            if (type == null || needCheckRepeat.contains(type) || !Module.class.isAssignableFrom(type) || type.getAnnotation(DimModule.class) == null) continue;
            needCheckRepeat.add(type);
            buildConfig.loadModules.add((Module)applicationContext.getBean(name));
        }
        if (enableHasor.scanPackages().length != 0) {
            AutoScanPackagesModule autoScanModule = new AutoScanPackagesModule(enableHasor.scanPackages(), Matchers.anyClassExcludes(needCheckRepeat));
            autoScanModule.setApplicationContext(Objects.requireNonNull(applicationContext));
            buildConfig.loadModules.add(autoScanModule);
        }
        for (Property property : customProperties = enableHasor.customProperties()) {
            String name = property.name();
            if (!StringUtils.isNotBlank((String)name)) continue;
            buildConfig.customProperties.put(name, property.value());
        }
        try {
            InputStream inputStream = ResourcesUtils.getResourceAsStream((String)"/META-INF/hasor-framework/hasor-spring-hello.txt");
            List helloText = IOUtils.readLines((InputStream)inputStream, (String)"utf-8");
            StringBuilder builder = new StringBuilder("\n");
            for (String msg : helloText) {
                builder.append(msg).append("\n");
            }
            logger.info(builder.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Bean
    @ConditionalOnNotWebApplication
    public AppContext normalAppContext(ApplicationContext applicationContext) {
        return this.createAppContext(null, applicationContext);
    }

    @Bean
    @ConditionalOnWebApplication
    public AppContext webAppContext(ApplicationContext applicationContext) {
        ServletContext parent = null;
        if (!(applicationContext instanceof WebApplicationContext)) {
            throw new IllegalStateException("miss ServletContext.");
        }
        parent = ((WebApplicationContext)applicationContext).getServletContext();
        return this.createAppContext(parent, applicationContext);
    }

    protected AppContext createAppContext(Object parentObject, ApplicationContext applicationContext) {
        try {
            return this.getBuildConfig().build(parentObject, applicationContext).build(new Module[]{apiBinder -> apiBinder.bindType(ApplicationContext.class).toInstance((Object)applicationContext)});
        }
        catch (IOException e) {
            throw ExceptionUtils.toRuntimeException((Throwable)e);
        }
    }
}

