/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.spring.web;

import java.util.function.Supplier;
import javax.servlet.ServletContext;
import net.hasor.core.AppContext;
import net.hasor.spring.SpringModule;
import net.hasor.utils.StringUtils;
import net.hasor.web.startup.RuntimeListener;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class SpringRuntimeListener
extends RuntimeListener {
    public SpringRuntimeListener() {
    }

    public SpringRuntimeListener(AppContext appContext) {
        super(appContext);
    }

    public SpringRuntimeListener(Supplier<AppContext> appContext) {
        super(appContext);
    }

    protected AppContext doInit(ServletContext sc) {
        ApplicationContext applicationContext;
        Object springContext = sc.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (springContext == null) {
            throw new IllegalStateException("Cannot initialize SpringRuntimeListener because spring application context not initialize.");
        }
        String contextBean = sc.getInitParameter("hasor-spring-bean");
        if (StringUtils.isBlank((String)contextBean)) {
            contextBean = SpringModule.DEFAULT_HASOR_BEAN_NAME;
        }
        if (!(applicationContext = (ApplicationContext)springContext).containsBean(contextBean)) {
            throw new IllegalStateException("Cannot initialize SpringRuntimeListener because spring application context not initialize.");
        }
        return (AppContext)applicationContext.getBean(contextBean);
    }
}

