/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.binder;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.servlet.Filter;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import net.hasor.core.ApiBinder;
import net.hasor.core.AppContext;
import net.hasor.core.BindInfo;
import net.hasor.core.binder.ApiBinderWrap;
import net.hasor.core.exts.aop.Matchers;
import net.hasor.core.provider.InstanceProvider;
import net.hasor.utils.CheckUtils;
import net.hasor.utils.StringUtils;
import net.hasor.web.InvokerFilter;
import net.hasor.web.ServletVersion;
import net.hasor.web.WebApiBinder;
import net.hasor.web.binder.FilterDef;
import net.hasor.web.binder.J2eeFilterAsFilter;
import net.hasor.web.binder.J2eeServletAsMapping;
import net.hasor.web.binder.MappingDef;
import net.hasor.web.binder.OneConfig;
import net.hasor.web.binder.RenderDef;
import net.hasor.web.binder.UriPatternMatcher;
import net.hasor.web.binder.UriPatternType;
import net.hasor.web.mime.MimeTypeSupplier;
import net.hasor.web.render.RenderEngine;

public class InvokerWebApiBinder
extends ApiBinderWrap
implements WebApiBinder {
    private final InstanceProvider<String> requestEncoding = new InstanceProvider((Object)"");
    private final InstanceProvider<String> responseEncoding = new InstanceProvider((Object)"");
    private ServletVersion curVersion;
    private MimeTypeSupplier mimeType;

    protected InvokerWebApiBinder(ServletVersion curVersion, MimeTypeSupplier mimeType, ApiBinder apiBinder) {
        super(apiBinder);
        apiBinder.bindType(String.class).nameWith("HTTP_REQUEST_ENCODING").toProvider(this.requestEncoding);
        apiBinder.bindType(String.class).nameWith("HTTP_RESPONSE_ENCODING").toProvider(this.responseEncoding);
        this.curVersion = Objects.requireNonNull(curVersion);
        this.mimeType = Objects.requireNonNull(mimeType);
    }

    @Override
    public ServletContext getServletContext() {
        return (ServletContext)this.getEnvironment().getContext();
    }

    @Override
    public WebApiBinder setRequestCharacter(String encoding) {
        this.requestEncoding.set((Object)encoding);
        return this;
    }

    @Override
    public WebApiBinder setResponseCharacter(String encoding) {
        this.responseEncoding.set((Object)encoding);
        return this;
    }

    @Override
    public String getMimeType(String suffix) {
        return this.mimeType.getMimeType(suffix);
    }

    @Override
    public void addMimeType(String type, String mimeType) {
        this.mimeType.addMimeType(type, mimeType);
    }

    @Override
    public void loadMimeType(Reader reader) throws IOException {
        this.mimeType.loadReader(reader);
    }

    @Override
    public ServletVersion getServletVersion() {
        return this.curVersion;
    }

    @Override
    public WebApiBinder.FilterBindingBuilder<InvokerFilter> filter(String[] morePatterns) {
        List uriPatterns = CheckUtils.checkEmpty(Arrays.asList(morePatterns), (String)"Filter patterns is empty.");
        return new FiltersModuleBinder<InvokerFilter>(InvokerFilter.class, UriPatternType.SERVLET, uriPatterns){

            @Override
            protected void bindThrough(int index, String pattern, UriPatternMatcher matcher, BindInfo<? extends InvokerFilter> filterRegister, Map<String, String> initParams) {
                InvokerWebApiBinder.this.filterThrough(index, pattern, matcher, filterRegister, initParams);
            }
        };
    }

    @Override
    public WebApiBinder.FilterBindingBuilder<InvokerFilter> filterRegex(String[] regexes) {
        List uriPatterns = CheckUtils.checkEmpty(Arrays.asList(regexes), (String)"Filter patterns is empty.");
        return new FiltersModuleBinder<InvokerFilter>(InvokerFilter.class, UriPatternType.REGEX, uriPatterns){

            @Override
            protected void bindThrough(int index, String pattern, UriPatternMatcher matcher, BindInfo<? extends InvokerFilter> filterRegister, Map<String, String> initParams) {
                InvokerWebApiBinder.this.filterThrough(index, pattern, matcher, filterRegister, initParams);
            }
        };
    }

    @Override
    public WebApiBinder.FilterBindingBuilder<Filter> jeeFilter(String[] morePatterns) throws NullPointerException {
        List uriPatterns = CheckUtils.checkEmpty(Arrays.asList(morePatterns), (String)"Filter patterns is empty.");
        return new FiltersModuleBinder<Filter>(Filter.class, UriPatternType.SERVLET, uriPatterns){

            @Override
            protected void bindThrough(int index, String pattern, UriPatternMatcher matcher, BindInfo<? extends Filter> filterRegister, Map<String, String> initParams) {
                InvokerWebApiBinder.this.jeeFilterThrough(index, pattern, matcher, filterRegister, initParams);
            }
        };
    }

    @Override
    public WebApiBinder.FilterBindingBuilder<Filter> jeeFilterRegex(String[] regexes) throws NullPointerException {
        List uriPatterns = CheckUtils.checkEmpty(Arrays.asList(regexes), (String)"Filter patterns is empty.");
        return new FiltersModuleBinder<Filter>(Filter.class, UriPatternType.REGEX, uriPatterns){

            @Override
            protected void bindThrough(int index, String pattern, UriPatternMatcher matcher, BindInfo<? extends Filter> filterRegister, Map<String, String> initParams) {
                InvokerWebApiBinder.this.jeeFilterThrough(index, pattern, matcher, filterRegister, initParams);
            }
        };
    }

    protected void jeeFilterThrough(int index, String pattern, UriPatternMatcher matcher, BindInfo<? extends Filter> filterRegister, Map<String, String> initParams) {
        if (!this.isSingleton(filterRegister)) {
            throw new IllegalStateException("Filter must be Singleton.");
        }
        J2eeFilterAsFilter filterAsFilter = new J2eeFilterAsFilter(this.getProvider(filterRegister));
        BindInfo bindInfo = this.bindType(J2eeFilterAsFilter.class).uniqueName().toInstance((Object)filterAsFilter).toInfo();
        this.filterThrough(index, pattern, matcher, (BindInfo<? extends InvokerFilter>)bindInfo, initParams);
    }

    protected void filterThrough(int index, String pattern, UriPatternMatcher matcher, BindInfo<? extends InvokerFilter> bindInfo, Map<String, String> initParams) {
        if (!this.isSingleton(bindInfo)) {
            throw new IllegalStateException("InvokerFilter must be Singleton.");
        }
        Supplier appContext = this.getProvider(AppContext.class);
        FilterDef define = new FilterDef(index, matcher, initParams, bindInfo, appContext);
        this.bindType(FilterDef.class).uniqueName().toInstance((Object)define);
    }

    protected void jeeServlet(int index, String pattern, BindInfo<? extends HttpServlet> servletRegister, Map<String, String> initParams) {
        if (!this.isSingleton(servletRegister)) {
            throw new IllegalStateException("HttpServlet must be Singleton.");
        }
        OneConfig oneConfig = new OneConfig(servletRegister.getBindID(), initParams, (Supplier<AppContext>)this.getProvider(AppContext.class));
        Supplier j2eeServlet = this.getProvider(servletRegister);
        this.mappingTo(pattern, new String[0]).with(index, new J2eeServletAsMapping(oneConfig, j2eeServlet));
    }

    @Override
    public WebApiBinder.ServletBindingBuilder jeeServlet(String[] morePatterns) {
        return new ServletsModuleBuilder(CheckUtils.checkEmpty(Arrays.asList(morePatterns), (String)"Servlet patterns is empty."));
    }

    @Override
    public <T> WebApiBinder.MappingToBindingBuilder<T> mappingTo(final String[] morePatterns) {
        CheckUtils.checkEmpty(Arrays.asList(morePatterns), (String)"mappingTo patterns is empty.");
        return new WebApiBinder.MappingToBindingBuilder<T>(){

            @Override
            public void with(int index, Class<? extends T> targetKey) {
                this.with(index, InvokerWebApiBinder.this.bindType(targetKey).uniqueName().toInfo());
            }

            @Override
            public void with(int index, T target) {
                Class<?> targetType = target.getClass();
                this.with(index, InvokerWebApiBinder.this.bindType(targetType).uniqueName().toInstance(target).toInfo());
            }

            @Override
            public void with(int index, Class<T> referKey, Supplier<? extends T> targetProvider) {
                this.with(index, InvokerWebApiBinder.this.bindType(referKey).uniqueName().toProvider(targetProvider).toInfo());
            }

            @Override
            public void with(int index, BindInfo<? extends T> targetInfo) {
                Arrays.stream(morePatterns).filter(StringUtils::isNotBlank).forEach(pattern -> {
                    MappingDef define = new MappingDef(index, targetInfo, (String)pattern, Matchers.anyMethod(), true);
                    InvokerWebApiBinder.this.bindType(MappingDef.class).uniqueName().toInstance((Object)define);
                });
                logger.info("mapingTo[{}] -> bindType '{}' mappingTo: '{}'.", new Object[]{targetInfo.getBindID(), targetInfo.getBindType(), morePatterns});
            }
        };
    }

    @Override
    public WebApiBinder.RenderEngineBindingBuilder addRender(String renderName) {
        return new RenderEngineBindingBuilderImpl(Objects.requireNonNull(renderName, "Render renderName is empty.")){

            @Override
            protected void bindRender(String renderName, BindInfo<? extends RenderEngine> bindInfo) {
                InvokerWebApiBinder.this.bindType(RenderDef.class).nameWith(renderName).toInstance((Object)new RenderDef(renderName, bindInfo));
            }
        };
    }

    private abstract class RenderEngineBindingBuilderImpl
    implements WebApiBinder.RenderEngineBindingBuilder {
        private String renderName;

        public RenderEngineBindingBuilderImpl(String renderName) {
            this.renderName = renderName;
        }

        @Override
        public <T extends RenderEngine> void to(Class<T> renderEngineType) {
            this.bindRender(this.renderName, (BindInfo<? extends RenderEngine>)InvokerWebApiBinder.this.bindType(RenderEngine.class).uniqueName().to(renderEngineType).toInfo());
        }

        @Override
        public void toProvider(Supplier<? extends RenderEngine> renderEngineProvider) {
            this.bindRender(this.renderName, (BindInfo<? extends RenderEngine>)InvokerWebApiBinder.this.bindType(RenderEngine.class).uniqueName().toProvider(renderEngineProvider).toInfo());
        }

        @Override
        public void bindToInfo(BindInfo<? extends RenderEngine> renderEngineInfo) {
            this.bindRender(this.renderName, Objects.requireNonNull(renderEngineInfo));
        }

        protected abstract void bindRender(String var1, BindInfo<? extends RenderEngine> var2);
    }

    private class ServletsModuleBuilder
    implements WebApiBinder.ServletBindingBuilder {
        private List<String> uriPatterns;

        ServletsModuleBuilder(List<String> uriPatterns) {
            this.uriPatterns = uriPatterns;
        }

        @Override
        public void with(int index, Class<? extends HttpServlet> servletKey, Map<String, String> initParams) {
            BindInfo servletRegister = InvokerWebApiBinder.this.bindType(HttpServlet.class).uniqueName().to(servletKey).toInfo();
            this.with(index, (BindInfo<? extends HttpServlet>)servletRegister, initParams);
        }

        @Override
        public void with(int index, HttpServlet servlet, Map<String, String> initParams) {
            BindInfo servletRegister = InvokerWebApiBinder.this.bindType(HttpServlet.class).uniqueName().toInstance((Object)servlet).toInfo();
            this.with(index, (BindInfo<? extends HttpServlet>)servletRegister, initParams);
        }

        @Override
        public void with(int index, Supplier<? extends HttpServlet> servletProvider, Map<String, String> initParams) {
            BindInfo servletRegister = InvokerWebApiBinder.this.bindType(HttpServlet.class).uniqueName().toProvider(servletProvider).asEagerSingleton().toInfo();
            this.with(index, (BindInfo<? extends HttpServlet>)servletRegister, initParams);
        }

        @Override
        public void with(int index, BindInfo<? extends HttpServlet> servletRegister, Map<String, String> initParams) {
            if (initParams == null) {
                initParams = new HashMap<String, String>();
            }
            for (String pattern : this.uriPatterns) {
                InvokerWebApiBinder.this.jeeServlet(index, pattern, servletRegister, initParams);
            }
            logger.info("mapingTo[Servlet] -> bindID '{}' mappingTo: '{}'.", (Object)servletRegister.getBindID(), this.uriPatterns);
        }
    }

    private abstract class FiltersModuleBinder<T>
    implements WebApiBinder.FilterBindingBuilder<T> {
        private final Class<T> targetType;
        private final UriPatternType uriPatternType;
        private final List<String> uriPatterns;

        FiltersModuleBinder(Class<T> targetType, UriPatternType uriPatternType, List<String> uriPatterns) {
            this.targetType = targetType;
            this.uriPatternType = uriPatternType;
            this.uriPatterns = uriPatterns;
        }

        @Override
        public void through(int index, Class<? extends T> filterKey, Map<String, String> initParams) {
            BindInfo filterRegister = InvokerWebApiBinder.this.bindType(this.targetType).uniqueName().to(filterKey).toInfo();
            this.through(index, filterRegister, initParams);
        }

        @Override
        public void through(int index, T filter, Map<String, String> initParams) {
            BindInfo filterRegister = InvokerWebApiBinder.this.bindType(this.targetType).uniqueName().toInstance(filter).toInfo();
            this.through(index, filterRegister, initParams);
        }

        @Override
        public void through(int index, Supplier<? extends T> filterProvider, Map<String, String> initParams) {
            BindInfo filterRegister = InvokerWebApiBinder.this.bindType(this.targetType).uniqueName().toProvider(filterProvider).asEagerSingleton().toInfo();
            this.through(index, filterRegister, initParams);
        }

        @Override
        public void through(int index, BindInfo<? extends T> filterRegister, Map<String, String> initParams) {
            if (initParams == null) {
                initParams = new HashMap<String, String>();
            }
            for (String pattern : this.uriPatterns) {
                UriPatternMatcher matcher = UriPatternType.get(this.uriPatternType, pattern);
                this.bindThrough(index, pattern, matcher, filterRegister, initParams);
            }
        }

        protected abstract void bindThrough(int var1, String var2, UriPatternMatcher var3, BindInfo<? extends T> var4, Map<String, String> var5);
    }
}

