/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.binder;

import java.io.IOException;
import javax.servlet.ServletContext;
import net.hasor.core.ApiBinder;
import net.hasor.core.Environment;
import net.hasor.core.binder.ApiBinderCreator;
import net.hasor.web.MimeType;
import net.hasor.web.ServletVersion;
import net.hasor.web.WebApiBinder;
import net.hasor.web.binder.InvokerWebApiBinder;
import net.hasor.web.mime.MimeTypeSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvokerWebApiBinderCreator
implements ApiBinderCreator<WebApiBinder> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public WebApiBinder createBinder(ApiBinder apiBinder) throws IOException {
        Environment environment = apiBinder.getEnvironment();
        Object context = environment.getContext();
        try {
            apiBinder.getEnvironment().getClassLoader().loadClass("javax.servlet.ServletContext");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        if (!(context instanceof ServletContext)) {
            return null;
        }
        return InvokerWebApiBinderCreator.newBinder(apiBinder);
    }

    public static WebApiBinder newBinder(ApiBinder apiBinder) throws IOException {
        Environment environment = apiBinder.getEnvironment();
        Object context = environment.getContext();
        if (!(context instanceof ServletContext)) {
            return null;
        }
        ServletContext servletContext = (ServletContext)context;
        MimeTypeSupplier mimeTypeContext = new MimeTypeSupplier(servletContext);
        mimeTypeContext.loadResource("/META-INF/mime.types.xml");
        mimeTypeContext.loadResource("mime.types.xml");
        apiBinder.bindType(MimeType.class, (Object)mimeTypeContext);
        ServletVersion curVersion = ServletVersion.V2_3;
        try {
            environment.getClassLoader().loadClass("javax.servlet.ServletRequestListener");
            curVersion = ServletVersion.V2_4;
            servletContext.getContextPath();
            curVersion = ServletVersion.V2_5;
            servletContext.getEffectiveMajorVersion();
            curVersion = ServletVersion.V3_0;
            servletContext.getVirtualServerName();
            curVersion = ServletVersion.V3_1;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        apiBinder.bindType(ServletContext.class).toInstance((Object)servletContext);
        apiBinder.bindType(ServletVersion.class).toInstance((Object)curVersion);
        return new InvokerWebApiBinder(curVersion, mimeTypeContext, apiBinder);
    }
}

