/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.binder;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.hasor.core.Environment;
import net.hasor.core.HasorUtils;
import net.hasor.core.Provider;
import net.hasor.web.Controller;
import net.hasor.web.Invoker;
import net.hasor.web.annotation.Any;
import net.hasor.web.binder.OneConfig;

public class J2eeServletAsMapping
implements Controller {
    private final OneConfig initParams;
    private AtomicBoolean inited;
    protected Supplier<? extends Servlet> targetServlet;

    public J2eeServletAsMapping(OneConfig initParams, Supplier<? extends Servlet> j2eeServlet) {
        this.initParams = initParams;
        this.inited = new AtomicBoolean(false);
        this.targetServlet = Provider.of(j2eeServlet).asSingle();
    }

    public Supplier<? extends Servlet> getTarget() {
        return this.targetServlet;
    }

    public ServletConfig getInitParams() {
        return this.initParams;
    }

    @Override
    public void initController(Invoker invoker) throws ServletException {
        if (!this.inited.compareAndSet(false, true)) {
            return;
        }
        this.targetServlet.get().init((ServletConfig)this.initParams);
        Environment environment = invoker.getAppContext().getEnvironment();
        HasorUtils.pushShutdownListener((Environment)environment, (event, eventData) -> this.destroy());
    }

    @Any
    public void doInvoke(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        if (!this.inited.get()) {
            throw new IllegalStateException("this Servlet uninitialized.");
        }
        this.targetServlet.get().service((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
        if (!this.inited.compareAndSet(true, false)) {
            return;
        }
        this.targetServlet.get().destroy();
    }
}

