/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.invoker;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.hasor.core.AppContext;
import net.hasor.core.spi.SpiTrigger;
import net.hasor.utils.future.BasicFuture;
import net.hasor.web.Invoker;
import net.hasor.web.Mapping;
import net.hasor.web.binder.FilterDef;
import net.hasor.web.binder.MappingDef;
import net.hasor.web.binder.OneConfig;
import net.hasor.web.invoker.ExceuteCaller;
import net.hasor.web.invoker.HttpParameters;
import net.hasor.web.invoker.InvokerCaller;
import net.hasor.web.invoker.InvokerChainInvocation;
import net.hasor.web.invoker.InvokerSupplier;
import net.hasor.web.invoker.RootInvokerCreater;
import net.hasor.web.spi.MappingDiscoverer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvokerContext {
    protected static Logger logger = LoggerFactory.getLogger(InvokerContext.class);
    private AppContext appContext = null;
    private Mapping[] invokeArray = new Mapping[0];
    private FilterDef[] filters = new FilterDef[0];
    private RootInvokerCreater invokerCreater = null;

    public void initContext(AppContext appContext, OneConfig configMap) throws Throwable {
        this.appContext = Objects.requireNonNull(appContext);
        List mappingList = appContext.findBindingBean(MappingDef.class);
        mappingList.sort(Comparator.comparingLong(MappingDef::getIndex));
        for (Mapping inMapping : this.invokeArray = mappingList.toArray(new Mapping[0])) {
            logger.info("mapingTo -> type '{}' mappingTo: '{}'.", (Object)inMapping.getTargetType().getBindType(), (Object)inMapping.getMappingTo());
        }
        SpiTrigger spiTrigger = (SpiTrigger)appContext.getInstance(SpiTrigger.class);
        for (Mapping mapping : this.invokeArray) {
            spiTrigger.notifySpiWithoutResult(MappingDiscoverer.class, listener -> listener.discover(mapping));
        }
        this.filters = (FilterDef[])appContext.findBindingBean(FilterDef.class).stream().sorted(Comparator.comparingLong(FilterDef::getIndex)).toArray(FilterDef[]::new);
        for (FilterDef filter : this.filters) {
            filter.init(configMap);
        }
        this.invokerCreater = new RootInvokerCreater(appContext);
    }

    public void destroyContext() {
        for (FilterDef filter : this.filters) {
            filter.destroy();
        }
    }

    public Invoker newInvoker(Mapping define, HttpServletRequest request, HttpServletResponse response) {
        return this.invokerCreater.createExt(new InvokerSupplier(define, this.appContext, request, response));
    }

    public ExceuteCaller genCaller(HttpServletRequest httpReq, HttpServletResponse httpRes) {
        Mapping foundDefine = null;
        for (Mapping define : this.invokeArray) {
            if (!define.matchingMapping(httpReq)) continue;
            foundDefine = define;
            break;
        }
        Invoker invoker = this.newInvoker(foundDefine, httpReq, httpRes);
        ExceuteCaller exceuteCaller = null;
        exceuteCaller = foundDefine == null ? chain -> {
            BasicFuture future = new BasicFuture();
            future.completed(new InvokerChainInvocation(this.filters, innerInv -> {
                if (chain != null) {
                    chain.doFilter((ServletRequest)innerInv.getHttpRequest(), (ServletResponse)innerInv.getHttpResponse());
                }
                return innerInv.get("resultData");
            }).doNext(invoker));
            return future;
        } : new InvokerCaller(() -> invoker, this.filters);
        ExceuteCaller finalExceuteCaller = exceuteCaller;
        return chain -> HttpParameters.preInvoke(invoker, paramData -> finalExceuteCaller.invoke(chain));
    }
}

