/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.invoker;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.hasor.core.AppContext;
import net.hasor.utils.StringUtils;
import net.hasor.utils.io.IOUtils;
import net.hasor.web.Invoker;
import net.hasor.web.Mapping;
import net.hasor.web.MimeType;
import net.hasor.web.invoker.InvokerCallerParamsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvokerSupplier
implements Invoker {
    protected static Logger logger = LoggerFactory.getLogger(InvokerSupplier.class);
    private Set<String> lockKeys = new HashSet<String>();
    private HttpServletRequest httpRequest = null;
    private HttpServletResponse httpResponse = null;
    private AppContext appContext = null;
    private String contentType = null;
    private MimeType mimeType = null;
    private Mapping ownerInMapping = null;
    private boolean jsonBodyBoolean = false;
    private String jsonBody = null;

    protected InvokerSupplier(Mapping ownerInMapping, AppContext appContext, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        this.ownerInMapping = ownerInMapping;
        this.appContext = appContext;
        this.httpRequest = httpRequest;
        this.httpResponse = httpResponse;
        this.mimeType = (MimeType)appContext.getInstance(MimeType.class);
        this.put("rootData", this);
        this.put("request", this.httpRequest);
        this.put("response", this.httpResponse);
        this.lockKey("rootData");
        this.lockKey("request");
        this.lockKey("response");
    }

    @Override
    public AppContext getAppContext() {
        return this.appContext;
    }

    @Override
    public HttpServletRequest getHttpRequest() {
        return this.httpRequest;
    }

    @Override
    public HttpServletResponse getHttpResponse() {
        return this.httpResponse;
    }

    @Override
    public Mapping ownerMapping() {
        return this.ownerInMapping;
    }

    @Override
    public String getJsonBodyString() {
        if (this.jsonBodyBoolean) {
            return this.jsonBody;
        }
        HttpServletRequest httpRequest = this.getHttpRequest();
        if (httpRequest.getContentType() != null && httpRequest.getContentType().contains("application/json")) {
            try (BufferedReader reader = httpRequest.getReader();){
                StringWriter writer = new StringWriter();
                IOUtils.copy((Reader)reader, (Writer)writer);
                this.jsonBody = writer.toString();
                this.jsonBodyBoolean = true;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.jsonBody;
    }

    @Override
    public String contentType() {
        String viewName;
        int lastIndex;
        if (StringUtils.isNotBlank((String)this.contentType)) {
            return this.contentType;
        }
        String contentType = this.ownerMapping().getSpecialContentType(this.getHttpRequest().getMethod());
        if (StringUtils.isBlank((String)contentType) && (lastIndex = (viewName = this.getRequestPath()).lastIndexOf(".")) > 0) {
            contentType = this.getMimeType(viewName.substring(lastIndex + 1));
        }
        return contentType;
    }

    @Override
    public void contentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public boolean isLockKey(String key) {
        return this.lockKeys.contains(key);
    }

    @Override
    public void lockKey(String key) {
        if (StringUtils.isBlank((String)key)) {
            return;
        }
        this.lockKeys.add(key);
    }

    @Override
    public String getMimeType(String suffix) {
        return this.mimeType.getMimeType(suffix);
    }

    @Override
    public <T> T fillForm(Class<? extends T> formType, T bean) {
        return new InvokerCallerParamsBuilder().getParamsParam(this, formType, bean);
    }
}

