/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.invoker;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.hasor.core.AppContext;
import net.hasor.core.Settings;
import net.hasor.core.XmlNode;
import net.hasor.utils.ClassUtils;
import net.hasor.utils.StringUtils;
import net.hasor.web.Invoker;
import net.hasor.web.InvokerCreator;

class RootInvokerCreater
implements InvokerCreator {
    protected Map<Class<?>, InvokerCreator> createrMap = new HashMap();
    protected Map<Class<?>, Class<?>> extMapping = new HashMap();

    public RootInvokerCreater(AppContext appContext) throws Exception {
        Settings settings = appContext.getEnvironment().getSettings();
        ClassLoader classLoader = appContext.getClassLoader();
        HashMap extBinderMap = new HashMap();
        XmlNode[] nodeArray = settings.getXmlNodeArray("hasor.invokerCreatorSet.invokerCreator");
        if (nodeArray != null && nodeArray.length > 0) {
            for (XmlNode atNode : nodeArray) {
                if (atNode == null) continue;
                String binderTypeStr = atNode.getAttribute("type");
                String binderImplStr = atNode.getText();
                if (StringUtils.isBlank((String)binderTypeStr) || StringUtils.isBlank((String)binderImplStr)) continue;
                Class<?> binderType = classLoader.loadClass(binderTypeStr);
                Class<?> binderImpl = classLoader.loadClass(binderImplStr);
                if (!binderType.isInterface()) continue;
                extBinderMap.put(binderType, binderImpl);
                List interfaces = ClassUtils.getAllInterfaces(binderType);
                for (Class faces : interfaces) {
                    extBinderMap.put(faces, binderImpl);
                }
            }
        }
        for (Map.Entry entry : extBinderMap.entrySet()) {
            if (this.extMapping.containsKey(entry.getKey())) continue;
            Class createrType = (Class)entry.getValue();
            this.extMapping.put((Class<?>)entry.getKey(), createrType);
            if (this.createrMap.containsKey(createrType)) continue;
            InvokerCreator creater = (InvokerCreator)createrType.newInstance();
            this.createrMap.put(createrType, creater);
        }
    }

    @Override
    public Invoker createExt(Invoker dataContext) {
        HashMap extMap = new HashMap();
        for (Map.Entry<Class<?>, InvokerCreator> entry : this.createrMap.entrySet()) {
            Invoker extObject;
            Class<?> clazz = entry.getKey();
            InvokerCreator creater = entry.getValue();
            Invoker invoker = extObject = creater != null ? creater.createExt(dataContext) : null;
            if (clazz == null || extObject == null) continue;
            extMap.put(clazz, extObject);
        }
        HashMap supportMap = new HashMap();
        supportMap.put(Invoker.class, dataContext);
        for (Map.Entry<Class<?>, Class<?>> entry : this.extMapping.entrySet()) {
            Class<?> key = entry.getKey();
            Class<?> value = entry.getValue();
            Object obj = extMap.get(value);
            if (obj == null) continue;
            supportMap.put(key, obj);
        }
        ClassLoader classLoader = dataContext.getAppContext().getClassLoader();
        Class[] classArray = supportMap.keySet().toArray(new Class[0]);
        return (Invoker)Proxy.newProxyInstance(classLoader, classArray, (InvocationHandler)new InvokerCreaterInvocationHandler(supportMap));
    }

    private static class InvokerCreaterInvocationHandler
    implements InvocationHandler {
        private Map<Class<?>, Object> supportMap;

        public InvokerCreaterInvocationHandler(Map<Class<?>, Object> supportMap) {
            this.supportMap = supportMap;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("toString")) {
                StringBuilder builder = new StringBuilder();
                builder = builder.append("count = ").append(this.supportMap.size()).append(" - [");
                for (Class<?> face : this.supportMap.keySet()) {
                    builder = builder.append(face.getName()).append(",");
                }
                if (builder.charAt(builder.length() - 1) == ',') {
                    builder = builder.deleteCharAt(builder.length() - 1);
                }
                builder.append("]");
                return builder.toString();
            }
            Class<?> declaringClass = method.getDeclaringClass();
            Object target = this.supportMap.get(declaringClass);
            if (target == null) {
                throw new UnsupportedOperationException("this method is not support -> " + method);
            }
            try {
                return method.invoke(target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

