/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.render;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.hasor.core.AppContext;
import net.hasor.core.Settings;
import net.hasor.utils.StringUtils;
import net.hasor.web.Invoker;
import net.hasor.web.InvokerChain;
import net.hasor.web.InvokerFilter;
import net.hasor.web.binder.RenderDef;
import net.hasor.web.render.RenderEngine;
import net.hasor.web.render.RenderInvoker;
import net.hasor.web.render.RenderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RenderInvokerFilter
implements InvokerFilter {
    private static final Logger logger = LoggerFactory.getLogger(RenderInvokerFilter.class);
    private String layoutPath = null;
    private boolean useLayout = true;
    private String templatePath = null;
    private final Map<String, RenderEngine> engineMap = new HashMap<String, RenderEngine>();
    private String placeholder = null;
    private String defaultLayout = null;

    RenderInvokerFilter() {
    }

    public void doInit(AppContext appContext) throws Throwable {
        List renderInfoList = appContext.findBindingBean(RenderDef.class);
        for (RenderDef renderInfo : renderInfoList) {
            String renderName = renderInfo.getRenderName();
            logger.info("web -> renderName {}.", (Object)renderName);
            this.engineMap.put(renderName.toUpperCase(), renderInfo.newEngine(appContext));
        }
        Settings settings = appContext.getEnvironment().getSettings();
        this.useLayout = settings.getBoolean("hasor.layout.enable", Boolean.valueOf(true));
        this.layoutPath = settings.getString("hasor.layout.layoutPath", "/layout");
        this.templatePath = settings.getString("hasor.layout.templatePath", "/templates");
        this.placeholder = settings.getString("hasor.layout.placeholder", "content_placeholder");
        this.defaultLayout = settings.getString("hasor.layout.defaultLayout", "default.htm");
        logger.info("RenderPlugin init -> useLayout={}, layoutPath={}, templatePath={}, placeholder={}, defaultLayout={}", new Object[]{this.useLayout, this.layoutPath, this.templatePath, this.placeholder, this.defaultLayout});
    }

    @Override
    public Object doInvoke(Invoker invoker, InvokerChain chain) throws Throwable {
        if (invoker instanceof RenderInvoker) {
            return this.doRenderInvoker((RenderInvoker)invoker, chain);
        }
        return chain.doNext(invoker);
    }

    private static RenderType findRenderType(Annotation[] annotations) {
        return Arrays.stream(annotations).map(annotation -> {
            if (annotation instanceof RenderType) {
                return (RenderType)annotation;
            }
            return annotation.annotationType().getAnnotation(RenderType.class);
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public Object doRenderInvoker(RenderInvoker invoker, InvokerChain chain) throws Throwable {
        RequestDispatcher requestDispatcher;
        if (this.useLayout) {
            invoker.layoutEnable();
        } else {
            invoker.layoutDisable();
        }
        RenderEngine specialEngine = null;
        if (invoker.ownerMapping() != null) {
            Method method = invoker.ownerMapping().findMethod(invoker.getHttpRequest());
            RenderType renderType = RenderInvokerFilter.findRenderType(method.getAnnotations());
            if (renderType == null) {
                renderType = RenderInvokerFilter.findRenderType(method.getDeclaringClass().getAnnotations());
            }
            if (renderType != null && StringUtils.isNotBlank((String)renderType.value())) {
                invoker.renderType(renderType.value());
                String mimeType = invoker.getMimeType(renderType.value());
                if (StringUtils.isNotBlank((String)mimeType)) {
                    invoker.contentType(mimeType);
                }
            }
            if (renderType != null && renderType.engineType() != RenderType.DEFAULT.class) {
                specialEngine = (RenderEngine)invoker.getAppContext().getInstance(renderType.engineType());
            }
        }
        Object returnData = chain.doNext(invoker);
        if (invoker.getHttpResponse().isCommitted()) {
            return returnData;
        }
        if (this.process(invoker, specialEngine)) {
            return returnData;
        }
        HttpServletRequest httpRequest = invoker.getHttpRequest();
        HttpServletResponse httpResponse = invoker.getHttpResponse();
        if (!httpResponse.isCommitted() && !StringUtils.isEmpty((String)invoker.renderTo()) && (requestDispatcher = httpRequest.getRequestDispatcher(invoker.renderTo())) != null) {
            requestDispatcher.forward((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        }
        return returnData;
    }

    public boolean process(RenderInvoker render, RenderEngine engine) throws Throwable {
        String renderType;
        if (engine == null && (engine = this.engineMap.get(renderType = render.renderType())) == null) {
            return false;
        }
        String oriViewName = render.renderTo();
        String newViewName = render.renderTo();
        if (render.layout()) {
            newViewName = this.templatePath + (oriViewName.charAt(0) != '/' ? "/" : "") + oriViewName;
        }
        String layoutFile = null;
        if (render.layout()) {
            layoutFile = this.findLayout(engine, oriViewName);
        }
        StringWriter finalWriter = new StringWriter();
        if (layoutFile != null) {
            StringWriter tmpWriter = new StringWriter();
            if (!engine.exist(newViewName)) {
                return false;
            }
            render.renderTo(newViewName);
            engine.process(render, tmpWriter);
            render.put(this.placeholder, tmpWriter.toString());
            if (engine.exist(layoutFile)) {
                render.renderTo(layoutFile);
                engine.process(render, finalWriter);
                return this.writerToResponse(finalWriter.toString(), render.getHttpResponse());
            }
            throw new IOException("layout '" + layoutFile + "' file is missing.");
        }
        if (engine.exist(newViewName)) {
            render.renderTo(newViewName);
            engine.process(render, finalWriter);
            return this.writerToResponse(finalWriter.toString(), render.getHttpResponse());
        }
        return false;
    }

    private boolean writerToResponse(String toString, HttpServletResponse httpResponse) throws IOException {
        byte[] finalBytes = toString.getBytes();
        httpResponse.setContentLength(finalBytes.length);
        ServletOutputStream outputStream = httpResponse.getOutputStream();
        outputStream.write(finalBytes);
        outputStream.flush();
        outputStream.close();
        return true;
    }

    protected String findLayout(RenderEngine engine, String tempFile) throws IOException {
        File layoutFile = new File(this.layoutPath, tempFile);
        if (engine.exist(layoutFile.getPath())) {
            return layoutFile.getPath();
        }
        if (engine.exist((layoutFile = new File(layoutFile.getParent(), this.defaultLayout)).getPath())) {
            return layoutFile.getPath();
        }
        while (layoutFile.getPath().startsWith(this.layoutPath)) {
            if (!engine.exist((layoutFile = new File(layoutFile.getParentFile().getParent(), this.defaultLayout)).getPath())) continue;
            return layoutFile.getPath();
        }
        return null;
    }
}

