/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.startup;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.hasor.core.AppContext;
import net.hasor.core.spi.SpiTrigger;
import net.hasor.utils.StringUtils;
import net.hasor.web.ServletVersion;
import net.hasor.web.binder.OneConfig;
import net.hasor.web.invoker.ExceuteCaller;
import net.hasor.web.invoker.InvokerContext;
import net.hasor.web.spi.AfterResponseListener;
import net.hasor.web.spi.BeforeRequestListener;
import net.hasor.web.startup.RuntimeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeFilter
implements Filter {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AtomicBoolean inited = new AtomicBoolean(false);
    public static final String HTTP_REQUEST_ENCODING_KEY = "HTTP_REQUEST_ENCODING";
    public static final String HTTP_RESPONSE_ENCODING_KEY = "HTTP_RESPONSE_ENCODING";
    private String httpRequestEncoding = null;
    private String httpResponseEncoding = null;
    private AppContext appContext = null;
    private SpiTrigger spiTrigger = null;
    private InvokerContext invokerContext = null;

    public RuntimeFilter() {
        this(null);
    }

    public RuntimeFilter(AppContext appContext) {
        this.appContext = appContext;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        if (!this.inited.compareAndSet(false, true)) {
            return;
        }
        if (this.appContext == null) {
            this.appContext = Objects.requireNonNull(RuntimeListener.getAppContext(filterConfig.getServletContext()), "AppContext has not been initialized.");
        }
        this.httpRequestEncoding = (String)this.appContext.findBindingBean(HTTP_REQUEST_ENCODING_KEY, String.class);
        this.httpResponseEncoding = (String)this.appContext.findBindingBean(HTTP_RESPONSE_ENCODING_KEY, String.class);
        try {
            this.spiTrigger = (SpiTrigger)this.appContext.getInstance(SpiTrigger.class);
            this.invokerContext = new InvokerContext();
            this.invokerContext.initContext(this.appContext, new OneConfig(filterConfig, () -> this.appContext));
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
        if (ServletVersion.V2_5.le((ServletVersion)((Object)this.appContext.getInstance(ServletVersion.class)))) {
            this.logger.info("RuntimeFilter started, at {}", (Object)filterConfig.getServletContext().getServerInfo());
        } else {
            this.logger.info("RuntimeFilter started, context at {}", (Object)filterConfig.getServletContext().getContextPath());
        }
    }

    public void destroy() {
        if (this.inited.compareAndSet(true, false)) {
            this.invokerContext.destroyContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpReq = (HttpServletRequest)request;
        HttpServletResponse httpRes = (HttpServletResponse)response;
        if (StringUtils.isNotBlank((String)this.httpRequestEncoding)) {
            httpReq.setCharacterEncoding(this.httpRequestEncoding);
        }
        if (StringUtils.isNotBlank((String)this.httpResponseEncoding)) {
            httpRes.setCharacterEncoding(this.httpResponseEncoding);
        }
        Object result = null;
        try {
            this.beforeRequest(this.appContext, httpReq, httpRes);
            result = this.doFilter(chain, httpReq, httpRes);
            this.afterResponse(this.appContext, httpReq, httpRes, result);
        }
        catch (Throwable throwable) {
            this.afterResponse(this.appContext, httpReq, httpRes, result);
            throw throwable;
        }
    }

    private Object doFilter(FilterChain chain, HttpServletRequest httpReq, HttpServletResponse httpRes) throws IOException, ServletException {
        Object result = null;
        try {
            ExceuteCaller caller = this.invokerContext.genCaller(httpReq, httpRes);
            if (caller != null) {
                Future<Object> resultData = caller.invoke(chain);
                if (resultData != null && resultData.isDone()) {
                    result = resultData.get();
                }
            } else {
                chain.doFilter((ServletRequest)httpReq, (ServletResponse)httpRes);
            }
        }
        catch (Throwable e) {
            if (e instanceof ExecutionException) {
                e = e.getCause();
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof ServletException) {
                throw (ServletException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new ServletException(e);
        }
        return result;
    }

    protected void beforeRequest(AppContext appContext, HttpServletRequest httpReq, HttpServletResponse httpRes) {
        this.spiTrigger.notifySpiWithoutResult(BeforeRequestListener.class, listener -> listener.doListener(appContext, httpReq, httpRes));
    }

    protected void afterResponse(AppContext appContext, HttpServletRequest httpReq, HttpServletResponse httpRes, Object result) {
        this.spiTrigger.notifySpiWithoutResult(AfterResponseListener.class, listener -> listener.doListener(appContext, httpReq, httpRes, result));
    }
}

