/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.valid;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.hasor.web.Invoker;
import net.hasor.web.valid.Message;
import net.hasor.web.valid.ValidBy;
import net.hasor.web.valid.Validation;

public interface ValidInvoker
extends Invoker {
    public static final String VALID_DATA_KEY = "validData";

    public List<String> validKeys();

    default public List<String> validErrorsOfString() {
        return this.validErrorsOfMessage().stream().map(Message::toString).collect(Collectors.toList());
    }

    default public List<String> validErrorsOfString(String key) {
        return this.validErrorsOfMessage(key).stream().map(Message::toString).collect(Collectors.toList());
    }

    default public String firstValidErrorsOfString(String key) {
        Message msg = this.firstValidErrorsOfMessage(key);
        return msg != null ? msg.toString() : null;
    }

    default public List<Message> validErrorsOfMessage() {
        ArrayList<Message> finalMessage = new ArrayList<Message>();
        for (String key : this.validKeys()) {
            finalMessage.addAll(this.validErrorsOfMessage(key));
        }
        return finalMessage;
    }

    public List<Message> validErrorsOfMessage(String var1);

    public Message firstValidErrorsOfMessage(String var1);

    public boolean isValid();

    public boolean isValid(String var1);

    default public void clearValidErrors() {
        for (String key : this.validKeys()) {
            this.clearValidErrors(key);
        }
    }

    public void clearValidErrors(String var1);

    default public void addError(String key, String validString) {
        this.addError(key, new Message(validString));
    }

    default public void addError(String key, String validString, Object ... args) {
        this.addError(key, new Message(validString, args));
    }

    default public void addError(String key, Message validMessage) {
        this.addErrors(key, Collections.singletonList(validMessage));
    }

    public void addErrors(String var1, List<Message> var2);

    default public boolean doValid(String scene, Object object) {
        if (object == null) {
            return false;
        }
        ValidBy[] byType = (ValidBy[])object.getClass().getAnnotationsByType(ValidBy.class);
        if (byType == null || byType.length == 0) {
            return false;
        }
        Class[] collect = (Class[])Arrays.stream(byType).flatMap(validBy -> Arrays.stream(validBy.value())).toArray(Class[]::new);
        return this.doValid(scene, object, collect);
    }

    default public boolean doValid(String scene, Object object, Class<? extends Validation> ... validArrays) {
        for (Class<? extends Validation> validType : validArrays) {
            Validation validation = (Validation)this.getAppContext().getInstance(validType);
            if (validation == null) {
                throw new NullPointerException("create " + validType.getName() + " Validation failed , return null.");
            }
            validation.doValidation(scene, object, this);
        }
        return this.isValid();
    }
}

