/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.binder;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.hasor.core.AppContext;
import net.hasor.core.BindInfo;
import net.hasor.web.Invoker;
import net.hasor.web.InvokerChain;
import net.hasor.web.InvokerConfig;
import net.hasor.web.InvokerFilter;
import net.hasor.web.binder.OneConfig;
import net.hasor.web.binder.UriPatternMatcher;

public class FilterDef
implements InvokerFilter {
    private final int index;
    private final UriPatternMatcher patternMatcher;
    private final OneConfig initParams;
    private final AtomicBoolean inited;
    private final BindInfo<?> targetType;
    private final Supplier<InvokerFilter> targetFilter;

    public FilterDef(int index, UriPatternMatcher patternMatcher, Map<String, String> initParams, BindInfo<? extends InvokerFilter> bindInfo, Supplier<AppContext> appContext) {
        this.index = index;
        this.patternMatcher = patternMatcher;
        this.initParams = new OneConfig(bindInfo.getBindID(), initParams, appContext);
        this.inited = new AtomicBoolean(false);
        this.targetType = bindInfo;
        this.targetFilter = () -> (InvokerFilter)((AppContext)appContext.get()).getInstance(bindInfo);
    }

    public int getIndex() {
        return this.index;
    }

    public boolean matchesInvoker(Invoker invoker) {
        String url = invoker.getRequestPath();
        return this.patternMatcher.matches(url);
    }

    public BindInfo<?> getTargetType() {
        return this.targetType;
    }

    public UriPatternMatcher getMatcher() {
        return this.patternMatcher;
    }

    public InvokerConfig getInitParams() {
        return this.initParams;
    }

    public String toString() {
        return String.format("pattern=%s ,uriPatternType=%s ,type %s ,initParams=%s ", this.patternMatcher.getPattern(), this.patternMatcher, this.getClass(), this.initParams);
    }

    @Override
    public final void init(InvokerConfig config) throws Throwable {
        if (!this.inited.compareAndSet(false, true)) {
            return;
        }
        if (config != null) {
            this.initParams.putConfig(config, true);
        }
        this.targetFilter().init(this.initParams);
    }

    @Override
    public Object doInvoke(Invoker invoker, InvokerChain chain) throws Throwable {
        if (!this.inited.get()) {
            throw new IllegalStateException("this Filter uninitialized.");
        }
        return this.targetFilter().doInvoke(invoker, chain);
    }

    private InvokerFilter targetFilter() {
        InvokerFilter filter = this.targetFilter.get();
        if (filter == null) {
            throw new NullPointerException("target InvokerFilter instance is null.");
        }
        return filter;
    }

    @Override
    public void destroy() {
        if (!this.inited.compareAndSet(true, false)) {
            return;
        }
        this.targetFilter.get().destroy();
    }
}

