/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.binder;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.servlet.http.HttpServletRequest;
import net.hasor.core.BindInfo;
import net.hasor.utils.BeanUtils;
import net.hasor.utils.StringUtils;
import net.hasor.web.Mapping;
import net.hasor.web.annotation.Async;
import net.hasor.web.annotation.HttpMethod;
import net.hasor.web.annotation.Produces;
import net.hasor.web.invoker.AsyncSupported;

public class MappingDef
implements Mapping {
    private final int index;
    private final BindInfo<?> targetType;
    private final String mappingTo;
    private final String mappingToMatches;
    private final Map<String, Method> httpMapping;
    private final Map<String, String> contentTypeMapping;
    private final Set<Method> asyncMethod;
    private AsyncSupported defaultAsync = AsyncSupported.no;

    public MappingDef(int index, BindInfo<?> targetType, String mappingTo, Predicate<Method> methodMatcher) {
        this(index, targetType, mappingTo, methodMatcher, true);
    }

    public MappingDef(int index, BindInfo<?> targetType, String mappingTo, Predicate<Method> methodMatcher, boolean needAnno) {
        this.targetType = Objects.requireNonNull(targetType, "targetType is null.");
        if (StringUtils.isBlank((String)mappingTo)) {
            throw new NullPointerException("'" + targetType.getBindType() + "' Service path is empty.");
        }
        if (!mappingTo.matches("/.+")) {
            throw new IllegalStateException("'" + targetType.getBindType() + "' Service path format error, must be a '/' at the start.");
        }
        if (targetType.getBindType().getAnnotation(Async.class) != null) {
            this.defaultAsync = AsyncSupported.yes;
        }
        this.index = index;
        this.mappingTo = mappingTo;
        this.mappingToMatches = MappingDef.wildToRegex(mappingTo).replaceAll("\\{\\w{1,}\\}", "([^/]{1,})");
        this.httpMapping = new HashMap<String, Method>();
        this.contentTypeMapping = new HashMap<String, String>();
        this.asyncMethod = new HashSet<Method>();
        List methodList = BeanUtils.getMethods((Class)targetType.getBindType());
        for (Method targetMethod : methodList) {
            Annotation[] annos;
            boolean matches = methodMatcher.test(targetMethod);
            if (!matches) continue;
            String metaType = null;
            Produces pro = targetMethod.getAnnotation(Produces.class);
            if (pro == null) {
                pro = targetMethod.getDeclaringClass().getAnnotation(Produces.class);
            }
            if (pro != null) {
                if (StringUtils.isBlank((String)pro.value())) {
                    throw new IllegalStateException(" @Produces value is empty. of " + targetMethod.toString());
                }
                metaType = pro.value();
            }
            if ((annos = targetMethod.getAnnotations()) != null) {
                for (Annotation anno : annos) {
                    String[] methodSet;
                    HttpMethod httpMethodAnno;
                    if (anno instanceof HttpMethod) {
                        String[] methodSet2;
                        for (String http : methodSet2 = ((HttpMethod)anno).value()) {
                            this.httpMapping.put(http.toUpperCase(), targetMethod);
                            if (!StringUtils.isNotBlank((String)metaType)) continue;
                            this.contentTypeMapping.put(http.toUpperCase(), metaType);
                        }
                    }
                    if ((httpMethodAnno = anno.annotationType().getAnnotation(HttpMethod.class)) == null) continue;
                    for (String http : methodSet = httpMethodAnno.value()) {
                        this.httpMapping.put(http.toUpperCase(), targetMethod);
                        if (!StringUtils.isNotBlank((String)metaType)) continue;
                        this.contentTypeMapping.put(http.toUpperCase(), metaType);
                    }
                }
            }
            if (this.httpMapping.isEmpty() && !needAnno) {
                this.httpMapping.put("ANY", targetMethod);
                if (StringUtils.isNotBlank((String)metaType)) {
                    this.contentTypeMapping.put("ANY", metaType);
                }
            }
            if (targetMethod.getAnnotation(Async.class) == null) continue;
            this.asyncMethod.add(targetMethod);
        }
    }

    private static String wildToRegex(String wild) {
        wild = wild.replace("\\", "\\\\");
        wild = wild.replace("$", "\\$");
        wild = wild.replace("^", "\\^");
        wild = wild.replace("[", "\\[");
        wild = wild.replace("]", "\\]");
        wild = wild.replace("(", "\\(");
        wild = wild.replace(")", "\\)");
        wild = wild.replace("|", "\\|");
        wild = wild.replace("+", "\\+");
        wild = wild.replace(".", "\\.");
        wild = wild.replace("*", ".*");
        wild = wild.replace("?", ".");
        return wild;
    }

    @Override
    public BindInfo<?> getTargetType() {
        return this.targetType;
    }

    @Override
    public String getMappingTo() {
        return this.mappingTo;
    }

    @Override
    public String getMappingToMatches() {
        return this.mappingToMatches;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public String[] getHttpMethodSet() {
        return this.httpMapping.keySet().toArray(new String[this.httpMapping.size()]);
    }

    @Override
    public boolean matchingMapping(HttpServletRequest request) {
        Objects.requireNonNull(request, "request is null.");
        String httpMethod = request.getMethod();
        String requestPath = this.evalRequestPath(request);
        if (!requestPath.matches(this.mappingToMatches)) {
            return false;
        }
        for (String m : this.httpMapping.keySet()) {
            if (httpMethod.equalsIgnoreCase(m)) {
                return true;
            }
            if (!"ANY".equalsIgnoreCase(m)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Method findMethod(String requestMethod) {
        Method targetMethod = this.httpMapping.get(requestMethod);
        if (targetMethod == null) {
            targetMethod = this.httpMapping.get("ANY");
        }
        return targetMethod;
    }

    @Override
    public String getSpecialContentType(String requestMethod) {
        String specialMetaType = this.contentTypeMapping.get(requestMethod.toUpperCase());
        if (specialMetaType == null) {
            specialMetaType = this.contentTypeMapping.get("ANY");
        }
        return specialMetaType;
    }

    @Override
    public boolean isAsync(HttpServletRequest request) {
        Method targetMethod = this.findMethod(request);
        if (targetMethod == null) {
            return false;
        }
        AsyncSupported async = this.asyncMethod.contains(targetMethod) ? AsyncSupported.yes : this.defaultAsync;
        return AsyncSupported.yes == async;
    }

    public Map<String, Method> getHttpMapping() {
        return this.httpMapping;
    }

    public String toString() {
        return String.format("pattern=%s ,methodSet=%s ,type %s", this.mappingTo, StringUtils.join((Object[])this.httpMapping.keySet().toArray(), (String)","), this.getTargetType());
    }

    private String evalRequestPath(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        String requestPath = request.getRequestURI();
        if (requestPath.startsWith(contextPath)) {
            requestPath = requestPath.substring(contextPath.length());
        }
        return requestPath;
    }
}

