/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.binder;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import net.hasor.core.AppContext;
import net.hasor.utils.Iterators;
import net.hasor.web.InvokerConfig;

public class OneConfig
extends HashMap<String, String>
implements FilterConfig,
ServletConfig,
InvokerConfig {
    private String resourceName;
    private Supplier<AppContext> appContext;

    public OneConfig() {
    }

    public OneConfig(String resourceName, Supplier<AppContext> appContext) {
        this();
        this.resourceName = resourceName;
        this.appContext = appContext;
    }

    public OneConfig(String resourceName, Map<String, String> initParams, Supplier<AppContext> appContext) {
        this();
        this.resourceName = resourceName;
        this.appContext = appContext;
        if (initParams != null) {
            this.putAll(initParams);
        }
    }

    public OneConfig(FilterConfig config, Supplier<AppContext> appContext) {
        this();
        this.resourceName = config.getFilterName();
        this.appContext = appContext;
        this.putConfig(config, true);
    }

    public OneConfig(ServletConfig config, Supplier<AppContext> appContext) {
        this();
        this.resourceName = config.getServletName();
        this.appContext = appContext;
        this.putConfig(config, true);
    }

    public OneConfig(String resourceName, InvokerConfig config, Supplier<AppContext> appContext) {
        this();
        this.resourceName = resourceName;
        this.appContext = appContext;
        this.putConfig(config, true);
    }

    public void putConfig(FilterConfig config, boolean overwrite) {
        Enumeration names = config.getInitParameterNames();
        if (names != null) {
            while (names.hasMoreElements()) {
                String name = names.nextElement().toString();
                this.computeIfAbsent(name, s -> overwrite ? config.getInitParameter(name) : s);
            }
        }
    }

    public void putConfig(ServletConfig config, boolean overwrite) {
        Enumeration names = config.getInitParameterNames();
        if (names != null) {
            while (names.hasMoreElements()) {
                String name = names.nextElement().toString();
                this.computeIfAbsent(name, s -> overwrite ? config.getInitParameter(name) : s);
            }
        }
    }

    public void putConfig(InvokerConfig config, boolean overwrite) {
        Enumeration<String> names = config.getInitParameterNames();
        if (names != null) {
            while (names.hasMoreElements()) {
                String name = names.nextElement().toString();
                this.computeIfAbsent(name, s -> overwrite ? config.getInitParameter(name) : s);
            }
        }
    }

    public String getFilterName() {
        return this.resourceName;
    }

    public String getServletName() {
        return this.resourceName;
    }

    public ServletContext getServletContext() {
        if (this.appContext != null) {
            AppContext appContext = this.appContext.get();
            return (ServletContext)appContext.getInstance(ServletContext.class);
        }
        return null;
    }

    @Override
    public String getInitParameter(String name) {
        return (String)this.get(name);
    }

    @Override
    public Enumeration<String> getInitParameterNames() {
        return Iterators.asEnumeration(this.keySet().iterator());
    }

    @Override
    public AppContext getAppContext() {
        return this.appContext.get();
    }
}

