/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.invoker;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import net.hasor.utils.StringUtils;
import net.hasor.utils.function.ESupplier;
import net.hasor.web.Invoker;
import net.hasor.web.Mapping;
import net.hasor.web.invoker.InvokerCaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpParameters {
    private static final Logger logger = LoggerFactory.getLogger(InvokerCaller.class);
    private static final ThreadLocal<Invoker> invokerLocal = new ThreadLocal();
    private static final ThreadLocal<Map<String, List<String>>> headerParamLocal = new ThreadLocal();
    private static final ThreadLocal<Map<String, List<String>>> cookieParamLocal = new ThreadLocal();
    private static final ThreadLocal<Map<String, List<String>>> pathParamLocal = new ThreadLocal();
    private static final ThreadLocal<Map<String, List<String>>> queryParamLocal = new ThreadLocal();
    private static final ThreadLocal<Map<String, List<String>>> requestParamLocal = new ThreadLocal();

    protected static <T> T executeWorker(Invoker invoker, ESupplier<T, Throwable> worker) throws Throwable {
        Objects.requireNonNull(invoker, "invoker is null.");
        try {
            invokerLocal.set(invoker);
            HttpParameters.init(invoker, invoker.getHttpRequest());
            Object object = worker.eGet();
            return (T)object;
        }
        finally {
            invokerLocal.remove();
            headerParamLocal.remove();
            cookieParamLocal.remove();
            pathParamLocal.remove();
            queryParamLocal.remove();
        }
    }

    private static void init(Invoker invoker, HttpServletRequest httpRequest) {
        Mapping ownerMapping;
        HashMap<String, List> cookieMap = new HashMap<String, List>();
        Cookie[] cookies = httpRequest.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                String cookieName = cookie.getName();
                String[] cookieValue = cookieMap.computeIfAbsent(cookieName, key -> new ArrayList());
                cookieValue.add(cookie.getValue());
            }
        }
        cookieParamLocal.set(cookieMap);
        HashMap headerMap = new HashMap();
        Enumeration headerNames = httpRequest.getHeaderNames();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String header = (String)headerNames.nextElement();
                Enumeration headers = httpRequest.getHeaders(header);
                if (headers == null) continue;
                ArrayList headerValue = new ArrayList();
                while (headers.hasMoreElements()) {
                    headerValue.add(headers.nextElement());
                }
                headerMap.put(header, headerValue);
            }
        }
        headerParamLocal.set(headerMap);
        String queryString = httpRequest.getQueryString();
        HashMap<String, List> queryMap = new HashMap<String, List>();
        if (StringUtils.isNotBlank((String)queryString)) {
            String[] params;
            for (String pData : params = queryString.split("&")) {
                List pArray;
                String encoding = httpRequest.getCharacterEncoding();
                String[] kv = pData.split("=");
                if (kv.length < 2) continue;
                String k = kv[0].trim();
                String v = kv[1];
                if (StringUtils.isNotBlank((String)encoding)) {
                    k = HttpParameters.urlDecoder(encoding, k);
                    v = HttpParameters.urlDecoder(encoding, v);
                }
                List list = pArray = (pArray = (List)queryMap.get(k)) == null ? new ArrayList() : pArray;
                if (!pArray.contains(v)) {
                    pArray.add(v);
                }
                queryMap.put(k, pArray);
            }
        }
        queryParamLocal.set(queryMap);
        HashMap<String, List> pathMap = new HashMap<String, List>();
        if (invoker != null && (ownerMapping = invoker.ownerMapping()) != null) {
            int i;
            String requestPath = httpRequest.getRequestURI().substring(httpRequest.getContextPath().length());
            String matchVar = ownerMapping.getMappingToMatches();
            String matchKey = "(?:\\{(\\w+)\\}){1,}";
            Matcher keyM = Pattern.compile(matchKey).matcher(ownerMapping.getMappingTo());
            Matcher varM = Pattern.compile(matchVar).matcher(requestPath);
            ArrayList<String> keyArray = new ArrayList<String>();
            ArrayList<String> varArray = new ArrayList<String>();
            while (keyM.find()) {
                keyArray.add(keyM.group(1));
            }
            varM.find();
            for (i = 1; i <= varM.groupCount(); ++i) {
                varArray.add(varM.group(i));
            }
            for (i = 0; i < keyArray.size(); ++i) {
                String k = (String)keyArray.get(i);
                String v = (String)varArray.get(i);
                List pArray = (List)pathMap.get(k);
                List list = pArray = pArray == null ? new ArrayList() : pArray;
                if (!pArray.contains(v)) {
                    pArray.add(v);
                }
                pathMap.put(k, pArray);
            }
        }
        pathParamLocal.set(pathMap);
        HashMap requestMap = new HashMap();
        Map parameterMap = httpRequest.getParameterMap();
        if (parameterMap != null) {
            parameterMap.forEach((key, value) -> requestMap.put(key, Arrays.asList(value)));
        }
        requestParamLocal.set(requestMap);
    }

    private static String urlDecoder(String encoding, String oriData) {
        try {
            if (StringUtils.isNotBlank((String)oriData)) {
                encoding = URLDecoder.decode(oriData, encoding);
            }
            return encoding;
        }
        catch (Exception e) {
            logger.warn("use '{}' decode '{}' error.", (Object)encoding, (Object)oriData);
            return encoding;
        }
    }

    private static Map<String, String> mapList2Map(Map<String, List<String>> mapList) {
        if (mapList == null) {
            return Collections.emptyMap();
        }
        Set<String> headerNames = mapList.keySet();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        for (String headerName : headerNames) {
            List<String> stringList = mapList.get(headerName);
            if (stringList.isEmpty()) continue;
            headerMap.put(headerName, stringList.get(stringList.size() - 1));
        }
        return headerMap;
    }

    private static boolean clearReplaceMap(Map<String, List<String>> target, Map<String, List<String>> newData) {
        if (newData == null) {
            return false;
        }
        target.clear();
        target.putAll(newData);
        return true;
    }

    private static boolean mergeReplaceMap(Map<String, List<String>> target, Map<String, List<String>> newData) {
        if (newData == null) {
            return false;
        }
        target.putAll(newData);
        return true;
    }

    private static boolean appendMap(Map<String, List<String>> target, Map<String, List<String>> newData) {
        if (newData == null) {
            return false;
        }
        Map<String, List<String>> listMap = target;
        newData.forEach((key, val) -> {
            List merge = listMap.merge((String)key, (List<String>)val, (first, second) -> {
                HashSet hashSet = new HashSet(first);
                hashSet.addAll(second);
                return Arrays.asList(hashSet.toArray(new String[0]));
            });
        });
        target.putAll(newData);
        return true;
    }

    public static Map<String, String> cookieMap() {
        return HttpParameters.mapList2Map(cookieParamLocal.get());
    }

    public static Map<String, List<String>> cookieArrayMap() {
        return cookieParamLocal.get();
    }

    public static boolean clearReplaceCookieArrayMap(Map<String, List<String>> newCookie) {
        return HttpParameters.clearReplaceMap(cookieParamLocal.get(), newCookie);
    }

    public static boolean mergeReplaceCookieArrayMap(Map<String, List<String>> newCookie) {
        return HttpParameters.mergeReplaceMap(cookieParamLocal.get(), newCookie);
    }

    public static boolean appendCookieArrayMap(Map<String, List<String>> newCookie) {
        return HttpParameters.appendMap(cookieParamLocal.get(), newCookie);
    }

    public static Invoker localInvoker() {
        return invokerLocal.get();
    }

    public static Map<String, String> headerMap() {
        return HttpParameters.mapList2Map(headerParamLocal.get());
    }

    public static Map<String, List<String>> headerArrayMap() {
        return headerParamLocal.get();
    }

    public static boolean clearReplaceHeaderArrayMap(Map<String, List<String>> newHeader) {
        return HttpParameters.clearReplaceMap(headerParamLocal.get(), newHeader);
    }

    public static boolean mergeReplaceHeaderArrayMap(Map<String, List<String>> newHeader) {
        return HttpParameters.mergeReplaceMap(headerParamLocal.get(), newHeader);
    }

    public static boolean appendHeaderArrayMap(Map<String, List<String>> newHeader) {
        return HttpParameters.appendMap(headerParamLocal.get(), newHeader);
    }

    public static Map<String, String> queryMap() {
        return HttpParameters.mapList2Map(queryParamLocal.get());
    }

    public static Map<String, List<String>> queryArrayMap() {
        return queryParamLocal.get();
    }

    public static boolean clearReplaceQueryArrayMap(Map<String, List<String>> newQuery) {
        return HttpParameters.clearReplaceMap(queryParamLocal.get(), newQuery);
    }

    public static boolean mergeReplaceQueryArrayMap(Map<String, List<String>> newQuery) {
        return HttpParameters.mergeReplaceMap(queryParamLocal.get(), newQuery);
    }

    public static boolean appendQueryArrayMap(Map<String, List<String>> newQuery) {
        return HttpParameters.appendMap(queryParamLocal.get(), newQuery);
    }

    public static Map<String, String> pathMap() {
        return HttpParameters.mapList2Map(pathParamLocal.get());
    }

    public static Map<String, List<String>> pathArrayMap() {
        return pathParamLocal.get();
    }

    public static boolean clearReplacePathArrayMap(Map<String, List<String>> newPath) {
        return HttpParameters.clearReplaceMap(pathParamLocal.get(), newPath);
    }

    public static boolean mergeReplacePathArrayMap(Map<String, List<String>> newPath) {
        return HttpParameters.mergeReplaceMap(pathParamLocal.get(), newPath);
    }

    public static boolean appendPathArrayMap(Map<String, List<String>> newPath) {
        return HttpParameters.appendMap(pathParamLocal.get(), newPath);
    }

    public static Map<String, String> requestMap() {
        return HttpParameters.mapList2Map(requestParamLocal.get());
    }

    public static Map<String, List<String>> requestArrayMap() {
        return requestParamLocal.get();
    }

    public static boolean clearReplaceRequestArrayMap(Map<String, List<String>> newRequestParam) {
        return HttpParameters.clearReplaceMap(requestParamLocal.get(), newRequestParam);
    }

    public static boolean mergeReplaceRequestArrayMap(Map<String, List<String>> newRequestParam) {
        return HttpParameters.mergeReplaceMap(requestParamLocal.get(), newRequestParam);
    }

    public static boolean appendRequestArrayMap(Map<String, List<String>> newRequestParam) {
        return HttpParameters.appendMap(requestParamLocal.get(), newRequestParam);
    }
}

