/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.invoker;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import javax.servlet.AsyncContext;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import net.hasor.utils.StringUtils;
import net.hasor.utils.future.BasicFuture;
import net.hasor.web.Controller;
import net.hasor.web.Invoker;
import net.hasor.web.InvokerChain;
import net.hasor.web.Mapping;
import net.hasor.web.ServletVersion;
import net.hasor.web.binder.FilterDef;
import net.hasor.web.invoker.AsyncInvocationWorker;
import net.hasor.web.invoker.ExecuteCaller;
import net.hasor.web.invoker.InvokerCallerParamsBuilder;
import net.hasor.web.invoker.InvokerChainInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InvokerCaller
extends InvokerCallerParamsBuilder
implements ExecuteCaller {
    protected static Logger logger = LoggerFactory.getLogger(InvokerCaller.class);
    private FilterDef[] filterArrays = null;
    private Supplier<Invoker> invokerSupplier = null;

    public InvokerCaller(Supplier<Invoker> invokerSupplier, FilterDef[] filterArrays) {
        this.invokerSupplier = invokerSupplier;
        this.filterArrays = filterArrays == null ? new FilterDef[]{} : filterArrays;
    }

    @Override
    public Future<Object> invoke(FilterChain chain) {
        final Invoker invoker = this.invokerSupplier.get();
        Mapping ownerMapping = invoker.ownerMapping();
        HttpServletRequest httpRequest = invoker.getHttpRequest();
        Method targetMethod = ownerMapping.findMethod(httpRequest);
        final BasicFuture future = new BasicFuture();
        boolean needAsync = ownerMapping.isAsync(httpRequest);
        ServletVersion version = (ServletVersion)((Object)invoker.getAppContext().getInstance(ServletVersion.class));
        if (version.ge(ServletVersion.V3_0) && needAsync) {
            AsyncContext asyncContext = httpRequest.startAsync((ServletRequest)httpRequest, (ServletResponse)invoker.getHttpResponse());
            asyncContext.start((Runnable)new AsyncInvocationWorker(asyncContext, targetMethod){

                @Override
                public void doWork(Method targetMethod) throws Throwable {
                    future.completed(InvokerCaller.this.invoke(targetMethod, invoker));
                }

                @Override
                public void doWorkWhenError(Method targetMethod, Throwable e) {
                    future.failed(e);
                }
            });
            return future;
        }
        try {
            Object invoke = this.invoke(targetMethod, invoker);
            future.completed(invoke);
        }
        catch (Throwable e) {
            future.failed(e);
        }
        return future;
    }

    private Object invoke(Method targetMethod, Invoker invoker) throws Throwable {
        Object targetObject = invoker.getAppContext().getInstance(invoker.ownerMapping().getTargetType());
        if (targetObject instanceof Controller) {
            ((Controller)targetObject).initController(invoker);
        }
        if (targetObject == null) {
            throw new NullPointerException("mappingToDefine newInstance is null.");
        }
        InvokerChain invokerChain = inv -> {
            String contentType = inv.contentType();
            if (StringUtils.isNotBlank((String)contentType) && !inv.getHttpResponse().isCommitted()) {
                inv.getHttpResponse().setContentType(contentType);
            }
            try {
                Object[] resolveParamsArrays = this.resolveParams(inv, targetMethod);
                Object result = targetMethod.invoke(targetObject, resolveParamsArrays);
                inv.put("resultData", result);
                return result;
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        };
        return new InvokerChainInvocation(this.filterArrays, invokerChain).doNext(invoker);
    }
}

