/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.invoker;

import com.alibaba.fastjson.JSON;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.hasor.core.AppContext;
import net.hasor.core.Environment;
import net.hasor.core.Settings;
import net.hasor.utils.BeanUtils;
import net.hasor.utils.StringUtils;
import net.hasor.utils.convert.ConverterUtils;
import net.hasor.web.Invoker;
import net.hasor.web.annotation.AttributeParameter;
import net.hasor.web.annotation.CookieParameter;
import net.hasor.web.annotation.HeaderParameter;
import net.hasor.web.annotation.ParameterGroup;
import net.hasor.web.annotation.PathParameter;
import net.hasor.web.annotation.QueryParameter;
import net.hasor.web.annotation.RequestBody;
import net.hasor.web.annotation.RequestParameter;
import net.hasor.web.annotation.WebParameter;
import net.hasor.web.invoker.HttpParameters;
import net.hasor.web.invoker.InvokerCaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvokerCallerParamsBuilder {
    protected static Logger logger = LoggerFactory.getLogger(InvokerCaller.class);

    public Object[] resolveParams(Invoker invoker, Method targetMethod) throws Throwable {
        Class<?>[] targetParamClass = targetMethod.getParameterTypes();
        Annotation[][] targetParamAnno = targetMethod.getParameterAnnotations();
        ArrayList<Object> paramsArray = new ArrayList<Object>();
        for (int i = 0; i < targetParamClass.length; ++i) {
            Class<?> paramClass = targetParamClass[i];
            Object paramObject = this.resolveParam(invoker, paramClass, targetParamAnno[i], true);
            paramsArray.add(paramObject);
        }
        return paramsArray.toArray();
    }

    private Object resolveParam(Invoker invoker, Class<?> paramClass, Annotation[] paramAnno, boolean useDefault) {
        Object specialParam = this.resolveSpecialParam(invoker, paramClass);
        if (specialParam != null) {
            return specialParam;
        }
        for (Annotation pAnno : paramAnno) {
            if (pAnno.annotationType().getAnnotation(WebParameter.class) == null) continue;
            Object finalValue = this.resolveParam(invoker, paramClass, pAnno);
            finalValue = ConverterUtils.convert(paramClass, (Object)finalValue);
            return finalValue;
        }
        if (useDefault) {
            return BeanUtils.getDefaultValue(paramClass);
        }
        return null;
    }

    private Object resolveSpecialParam(Invoker invoker, Class<?> paramClass) {
        if (!paramClass.isInterface()) {
            return null;
        }
        if (paramClass == ServletRequest.class || paramClass == HttpServletRequest.class) {
            return invoker.getHttpRequest();
        }
        if (paramClass == ServletResponse.class || paramClass == HttpServletResponse.class) {
            return invoker.getHttpResponse();
        }
        if (paramClass == HttpSession.class) {
            return invoker.getHttpRequest().getSession(true);
        }
        if (paramClass == ServletContext.class) {
            return invoker.getAppContext().getInstance(ServletContext.class);
        }
        if (paramClass == Invoker.class || paramClass.isInstance(invoker)) {
            return invoker;
        }
        if (paramClass == AppContext.class) {
            return invoker.getAppContext();
        }
        if (paramClass == Environment.class) {
            return invoker.getAppContext().getEnvironment();
        }
        if (paramClass == Settings.class) {
            return invoker.getAppContext().getEnvironment().getSettings();
        }
        return null;
    }

    private Object resolveParam(Invoker invoker, Class<?> paramClass, Annotation pAnno) {
        Object atData = null;
        if (pAnno instanceof AttributeParameter) {
            atData = this.getAttributeParam(invoker, (AttributeParameter)pAnno);
        } else if (pAnno instanceof CookieParameter) {
            atData = this.getCookieParam((CookieParameter)pAnno);
        } else if (pAnno instanceof HeaderParameter) {
            atData = this.getHeaderParam((HeaderParameter)pAnno);
        } else if (pAnno instanceof QueryParameter) {
            atData = this.getQueryParam((QueryParameter)pAnno);
        } else if (pAnno instanceof PathParameter) {
            atData = this.getPathParam((PathParameter)pAnno);
        } else if (pAnno instanceof RequestParameter) {
            atData = this.getRequestParam((RequestParameter)pAnno);
        } else if (pAnno instanceof RequestBody) {
            String jsonBodyString = invoker.getJsonBodyString();
            if (jsonBodyString == null) {
                atData = null;
            } else {
                String jsonBodyData = jsonBodyString.trim();
                if (paramClass == String.class) {
                    atData = jsonBodyData;
                } else if (paramClass == Map.class) {
                    atData = JSON.parseObject((String)jsonBodyData);
                } else if (paramClass == List.class) {
                    jsonBodyData = jsonBodyData.charAt(0) != '[' ? "[" + jsonBodyData + "]" : jsonBodyData;
                    atData = JSON.parseArray((String)jsonBodyData, ArrayList.class);
                } else if (paramClass == Set.class) {
                    jsonBodyData = jsonBodyData.charAt(0) != '[' ? "[" + jsonBodyData + "]" : jsonBodyData;
                    atData = JSON.parseArray((String)jsonBodyData, HashSet.class);
                } else {
                    atData = JSON.parseObject((String)jsonBodyData, paramClass);
                }
            }
        } else if (pAnno instanceof ParameterGroup) {
            try {
                atData = invoker.getAppContext().justInject(paramClass.newInstance());
                atData = this.getParamsParam(invoker, paramClass, atData);
            }
            catch (Throwable e) {
                logger.error(paramClass.getName() + "newInstance error.", (Object)e.getMessage());
                atData = null;
            }
        }
        return atData;
    }

    public <T> T getParamsParam(Invoker invoker, Class<? extends T> paramClass, T paramObject) {
        if (paramObject == null) {
            return null;
        }
        List fieldList = BeanUtils.findALLFields(paramClass);
        if (fieldList == null || fieldList.isEmpty()) {
            return paramObject;
        }
        for (Field field : fieldList) {
            try {
                Object fieldValue = null;
                Annotation[] annos = field.getAnnotations();
                if (annos == null || annos.length <= 0 || (fieldValue = this.resolveParam(invoker, field.getType(), annos, false)) == null) continue;
                fieldValue = ConverterUtils.convert(field.getType(), (Object)fieldValue);
                field.setAccessible(true);
                field.set(paramObject, fieldValue);
            }
            catch (Exception e) {
                logger.error(field + "set new Value error.", (Object)e.getMessage());
            }
        }
        return paramObject;
    }

    private Object getAttributeParam(Invoker invoker, AttributeParameter pAnno) {
        String paramName = pAnno.value();
        if (StringUtils.isBlank((String)paramName)) {
            return null;
        }
        HttpServletRequest httpRequest = invoker.getHttpRequest();
        Enumeration e = httpRequest.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = e.nextElement().toString();
            if (!name.equalsIgnoreCase(paramName)) continue;
            return httpRequest.getAttribute(paramName);
        }
        return null;
    }

    private Object getPathParam(PathParameter pAnno) {
        String paramName = pAnno.value();
        return StringUtils.isBlank((String)paramName) ? null : HttpParameters.pathArrayMap().get(paramName);
    }

    private Object getQueryParam(QueryParameter pAnno) {
        String paramName = pAnno.value();
        return StringUtils.isBlank((String)paramName) ? null : HttpParameters.queryArrayMap().get(paramName);
    }

    private Object getHeaderParam(HeaderParameter pAnno) {
        String paramName = pAnno.value();
        return StringUtils.isBlank((String)paramName) ? null : HttpParameters.headerArrayMap().get(paramName);
    }

    private Object getCookieParam(CookieParameter pAnno) {
        String paramName = pAnno.value();
        return StringUtils.isBlank((String)paramName) ? null : HttpParameters.cookieArrayMap().get(paramName);
    }

    private Object getRequestParam(RequestParameter pAnno) {
        String paramName = pAnno.value();
        return StringUtils.isBlank((String)paramName) ? null : HttpParameters.requestArrayMap().get(paramName);
    }
}

