/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.objects;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.hasor.utils.StringUtils;
import net.hasor.web.Invoker;
import net.hasor.web.InvokerChain;
import net.hasor.web.InvokerFilter;
import net.hasor.web.Mapping;

public class CorsFilter
implements InvokerFilter {
    @Override
    public Object doInvoke(Invoker invoker, InvokerChain chain) throws Throwable {
        String httpMethod = invoker.getHttpRequest().getMethod();
        Mapping mapping = invoker.ownerMapping();
        if (mapping != null && mapping.findMethod("OPTIONS") != null) {
            return chain.doNext(invoker);
        }
        HttpServletRequest httpRequest = invoker.getHttpRequest();
        HttpServletResponse httpResponse = invoker.getHttpResponse();
        String originString = httpRequest.getHeader("Origin");
        if (StringUtils.isNotBlank((String)originString)) {
            httpResponse.setHeader("Access-Control-Allow-Origin", originString);
            httpResponse.setHeader("Access-Control-Allow-Credentials", "true");
        } else {
            httpResponse.setHeader("Access-Control-Allow-Origin", "*");
        }
        httpResponse.addHeader("Access-Control-Allow-Methods", "*");
        httpResponse.addHeader("Access-Control-Allow-Headers", "content-type");
        httpResponse.addHeader("Access-Control-Max-Age", "3600");
        if ("OPTIONS".equalsIgnoreCase(httpMethod)) {
            return null;
        }
        return chain.doNext(invoker);
    }
}

