/*
 * Decompiled with CFR 0.152.
 */
package org.bn.compiler;

import antlr.ANTLRException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.transform.TransformerException;
import org.bn.compiler.CompilerArgs;
import org.bn.compiler.Module;
import org.bn.compiler.parser.ASNLexer;
import org.bn.compiler.parser.ASNParser;
import org.bn.compiler.parser.model.ASN1Model;
import org.bn.compiler.parser.model.ASNModule;
import org.lineargs.LineArgsParser;

public class Main {
    private static final String VERSION = Main.class.getPackage().getImplementationVersion();
    private CompilerArgs arguments = null;

    public static void main(String[] args) {
        try {
            System.out.println("BinaryNotes compiler v" + VERSION);
            System.out.println("        (c) 2006-2022 Abdulla G. Abdurakhmanov, Pavel Drasil, Markus Heberling");
            new Main().start(args);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    public void start(String[] args) throws Exception {
        LineArgsParser parser = new LineArgsParser();
        if (args.length > 0) {
            this.arguments = (CompilerArgs)parser.parse(CompilerArgs.class, args);
            Module module = new Module(this.arguments.getModuleName(), this.arguments.getOutputDir());
            this.startForModule(module);
        } else {
            parser.printHelp(CompilerArgs.class, System.out);
        }
    }

    private void startForModule(Module module) throws TransformerException, JAXBException, IOException, ANTLRException {
        if (!this.arguments.getGenerateModelOnly().booleanValue()) {
            System.out.println("Current directory: " + new File(".").getCanonicalPath());
            System.out.println("Compiling file: " + this.arguments.getInputFileName());
            ByteArrayOutputStream outputXml = new ByteArrayOutputStream(65535);
            this.createModel(outputXml, module);
            module.translate(new ByteArrayInputStream(outputXml.toByteArray()));
        } else {
            this.createModel(System.out, null);
        }
    }

    private void createModel(OutputStream outputXml, Module module) throws JAXBException, FileNotFoundException, ANTLRException {
        ASN1Model model = this.createModelFromStream();
        if (module != null) {
            model.outputDirectory = module.getOutputDir();
            model.moduleNS = this.arguments.getNamespace() != null ? this.arguments.getNamespace() : model.module.moduleIdentifier.name.toLowerCase();
        }
        JAXBContext jc = JAXBContext.newInstance((String)"org.bn.compiler.parser.model");
        Marshaller marshaller = jc.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal((Object)model, outputXml);
    }

    private ASN1Model createModelFromStream() throws FileNotFoundException, ANTLRException {
        FileInputStream stream = new FileInputStream(this.arguments.getInputFileName());
        ASNLexer lexer = new ASNLexer(stream);
        ASNParser parser = new ASNParser(lexer);
        ASNModule module = new ASNModule();
        parser.module_definition(module);
        ASN1Model model = new ASN1Model();
        model.module = module;
        return model;
    }
}

