/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.SubCache;
import au.id.jericho.lib.html.Tag;
import au.id.jericho.lib.html.TagType;
import java.util.Iterator;

final class Cache {
    public final Source source;
    private final SubCache allTagTypesSubCache;
    private final SubCache[] subCaches;

    public Cache(Source source) {
        this.source = source;
        this.allTagTypesSubCache = new SubCache(this, null);
        TagType[] separatelyCachedTagTypes = Cache.getSeparatelyCachedTagTypes();
        this.subCaches = new SubCache[separatelyCachedTagTypes.length + 1];
        this.subCaches[0] = this.allTagTypesSubCache;
        for (int i = 0; i < separatelyCachedTagTypes.length; ++i) {
            this.subCaches[i + 1] = new SubCache(this, separatelyCachedTagTypes[i]);
        }
    }

    public Tag getTagAt(int pos) {
        return this.allTagTypesSubCache.getTagAt(pos);
    }

    public Tag findPreviousOrNextTag(int pos, boolean previous) {
        return this.allTagTypesSubCache.findPreviousOrNextTag(pos, previous);
    }

    public Tag findPreviousOrNextTag(int pos, TagType tagType, boolean previous) {
        for (int i = 0; i < this.subCaches.length; ++i) {
            if (tagType != this.subCaches[i].tagType) continue;
            return this.subCaches[i].findPreviousOrNextTag(pos, previous);
        }
        return Tag.findPreviousOrNextTagUncached(this.source, pos, tagType, previous, -1);
    }

    public Tag addTagAt(int pos) {
        Tag tag = Tag.getTagAtUncached(this.source, pos);
        this.allTagTypesSubCache.addTagAt(pos, tag);
        if (tag == null) {
            return tag;
        }
        TagType tagType = tag.getTagType();
        for (int i = 1; i < this.subCaches.length; ++i) {
            if (tagType != this.subCaches[i].tagType) continue;
            this.subCaches[i].addTagAt(pos, tag);
            return tag;
        }
        return tag;
    }

    public Iterator getTagIterator() {
        return this.allTagTypesSubCache.getTagIterator();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.subCaches.length; ++i) {
            this.subCaches[i].appendTo(sb);
        }
        return sb.toString();
    }

    protected int getSourceLength() {
        return this.source.getEnd();
    }

    private static TagType[] getSeparatelyCachedTagTypes() {
        return TagType.getTagTypesIgnoringEnclosedMarkup();
    }
}

