/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Attributes;
import au.id.jericho.lib.html.EndTag;
import au.id.jericho.lib.html.FormControl;
import au.id.jericho.lib.html.HTMLElementName;
import au.id.jericho.lib.html.HTMLElements;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StartTag;

public final class Element
extends Segment
implements HTMLElementName {
    private StartTag startTag;
    private EndTag endTag = null;
    private Segment content = null;

    Element(Source source, StartTag startTag, EndTag endTag) {
        super(source, startTag.begin, endTag == null ? startTag.end : endTag.end);
        this.startTag = startTag;
        this.endTag = endTag == null || endTag.length() == 0 ? null : endTag;
    }

    public Segment getContent() {
        if (this.content == null) {
            this.content = new Segment(this.source, this.startTag.end, this.getContentEnd());
        }
        return this.content;
    }

    public StartTag getStartTag() {
        return this.startTag;
    }

    public EndTag getEndTag() {
        return this.endTag;
    }

    public String getName() {
        return this.startTag.getName();
    }

    public boolean isEmpty() {
        return this.startTag.end == this.getContentEnd();
    }

    public boolean isEmptyElementTag() {
        return this.isEmpty() && this.startTag.isEmptyElementTag();
    }

    public Attributes getAttributes() {
        return this.getStartTag().getAttributes();
    }

    public String getAttributeValue(String attributeName) {
        return this.getStartTag().getAttributeValue(attributeName);
    }

    public FormControl getFormControl() {
        return FormControl.construct(this);
    }

    public String getDebugInfo() {
        return "Element " + super.getDebugInfo() + ": " + this.startTag.getDebugInfo() + "-" + (this.endTag == null ? "(no end tag)" : this.endTag.getDebugInfo());
    }

    public String getContentText() {
        return this.isEmpty() ? null : this.toString();
    }

    public static boolean isBlock(String elementName) {
        return HTMLElements.getBlockLevelElementNames().contains(elementName.toLowerCase());
    }

    public static boolean isInline(String elementName) {
        return HTMLElements.getInlineLevelElementNames().contains(elementName.toLowerCase());
    }

    private int getContentEnd() {
        return this.endTag != null ? this.endTag.begin : this.end;
    }
}

