/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.EndTagType;
import au.id.jericho.lib.html.ParseText;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.Tag;

public class EndTagTypeGenericImplementation
extends EndTagType {
    private final String staticString;

    protected EndTagTypeGenericImplementation(String description, String startDelimiter, String closingDelimiter, boolean isServerTag, boolean isStatic) {
        super(description, startDelimiter, closingDelimiter, isServerTag);
        this.staticString = isStatic ? startDelimiter + closingDelimiter : null;
    }

    protected final boolean isStatic() {
        return this.staticString != null;
    }

    public String generateHTML(String startTagName) {
        return this.staticString != null ? this.staticString : "</" + startTagName + this.getClosingDelimiter();
    }

    protected Tag constructTagAt(Source source, int pos) {
        ParseText parseText = source.getParseText();
        int nameBegin = pos + "</".length();
        String name = null;
        int startDelimiterEnd = pos + this.getStartDelimiter().length();
        int end = -1;
        if (this.isStatic()) {
            name = this.getNamePrefix();
            if (!parseText.containsAt(this.getClosingDelimiter(), startDelimiterEnd)) {
                source.log("EndTag of expected format", this.staticString, pos, "not recognised as type '", this.getDescription(), "' because it is missing the closing delimiter", -1);
                return null;
            }
            end = startDelimiterEnd + this.getClosingDelimiter().length();
        } else {
            int nameEnd = source.findNameEnd(startDelimiterEnd);
            if (nameEnd == -1) {
                return null;
            }
            name = parseText.substring(nameBegin, nameEnd);
            if (!parseText.containsAt(this.getClosingDelimiter(), nameEnd)) {
                source.log("EndTag", name, pos, "not recognised as type '", this.getDescription(), "' because its closing delimiter does not immediately follow its name", -1);
                return null;
            }
            end = nameEnd + this.getClosingDelimiter().length();
        }
        return this.constructEndTag(source, pos, end, name);
    }
}

