/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Config;
import au.id.jericho.lib.html.FormControl;
import au.id.jericho.lib.html.FormField;
import au.id.jericho.lib.html.OutputDocument;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class FormFields
extends AbstractCollection {
    private final LinkedHashMap map = new LinkedHashMap();
    private final ArrayList formControls = new ArrayList();
    private Column[] columns = null;

    public FormFields(Collection formControls) {
        Iterator i = formControls.iterator();
        while (i.hasNext()) {
            FormControl formControl = (FormControl)i.next();
            if (formControl.getName() == null || formControl.getName().length() == 0) continue;
            formControl.addToFormFields(this);
            this.formControls.add(formControl);
        }
    }

    public int getCount() {
        return this.map.size();
    }

    public int size() {
        return this.getCount();
    }

    public FormField get(String fieldName) {
        if (Config.CurrentCompatibilityMode.isFormFieldNameCaseInsensitive()) {
            fieldName = fieldName.toLowerCase();
        }
        return (FormField)this.map.get(fieldName);
    }

    public Iterator iterator() {
        return ((HashMap)this.map).values().iterator();
    }

    public Collection getValues(String fieldName) {
        FormField formField = this.get(fieldName);
        return formField == null ? null : formField.getValues();
    }

    public Map getDataSet() {
        HashMap<String, String[]> map = new HashMap<String, String[]>((int)((double)this.getCount() / 0.7));
        Iterator i = this.iterator();
        while (i.hasNext()) {
            FormField formField = (FormField)i.next();
            Collection values = formField.getValues();
            if (values.isEmpty()) continue;
            String[] valuesArray = new String[values.size()];
            Iterator valuesIterator = values.iterator();
            for (int x = 0; x < values.size(); ++x) {
                valuesArray[x] = valuesIterator.next().toString();
            }
            map.put(formField.getName(), valuesArray);
        }
        return map;
    }

    public void clearValues() {
        Iterator i = ((AbstractList)this.formControls).iterator();
        while (i.hasNext()) {
            ((FormControl)i.next()).clearValues();
        }
    }

    public void setDataSet(Map dataSet) {
        this.clearValues();
        if (this.map == null) {
            return;
        }
        Iterator i = dataSet.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String fieldName = entry.getKey().toString();
            FormField formField = this.get(fieldName);
            if (formField == null) continue;
            if (entry.getValue() instanceof Collection) {
                formField.addValues((Collection)entry.getValue());
                continue;
            }
            formField.addValues((CharSequence[])entry.getValue());
        }
    }

    public boolean setValue(String fieldName, CharSequence value) {
        FormField formField = this.get(fieldName);
        return formField == null ? false : formField.setValue(value);
    }

    public boolean addValue(String fieldName, CharSequence value) {
        FormField formField = this.get(fieldName);
        return formField == null ? false : formField.addValue(value);
    }

    public String[] getColumnLabels() {
        this.initColumns();
        String[] columnLabels = new String[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            Column column = this.columns[i];
            String fieldName = column.formField.getFirstFormControl().getName();
            columnLabels[i] = column.predefinedValue != null ? fieldName + '.' + column.predefinedValue : fieldName;
        }
        return columnLabels;
    }

    public String[] getColumnValues(Map dataSet) {
        this.initColumns();
        String[] columnValues = new String[this.columns.length];
        if (Config.ColumnValueFalse != null) {
            for (int i = 0; i < this.columns.length; ++i) {
                if (!this.columns[i].isBoolean) continue;
                columnValues[i] = Config.ColumnValueFalse;
            }
        }
        Iterator i = dataSet.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String fieldName = entry.getKey().toString();
            FormField formField = this.get(fieldName);
            if (formField == null) continue;
            List<CharSequence> values = entry.getValue() instanceof Collection ? (List<CharSequence>)entry.getValue() : Arrays.asList((CharSequence[])entry.getValue());
            int columnIndex = formField.columnIndex;
            Iterator valueIterator = values.iterator();
            block2: while (valueIterator.hasNext()) {
                String value = valueIterator.next().toString();
                for (int ci = columnIndex; ci < this.columns.length; ++ci) {
                    Column column = this.columns[ci];
                    if (column.formField != formField) continue block2;
                    if (column.predefinedValue != null) {
                        if (!column.predefinedValue.equals(value)) continue;
                        columnValues[ci] = Config.ColumnValueTrue;
                        continue block2;
                    }
                    if (column.isBoolean) {
                        if (value == null) continue block2;
                        columnValues[ci] = Config.ColumnValueTrue;
                        continue block2;
                    }
                    if (columnValues[ci] == null) {
                        columnValues[ci] = value;
                        continue block2;
                    }
                    columnValues[ci] = columnValues[ci] + Config.ColumnMultipleValueSeparator + value;
                    continue block2;
                }
            }
        }
        return columnValues;
    }

    public String[] getColumnValues() {
        return this.getColumnValues(this.getDataSet());
    }

    private void initColumns() {
        if (this.columns != null) {
            return;
        }
        ArrayList<Column> columnList = new ArrayList<Column>();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            FormField formField = (FormField)i.next();
            formField.columnIndex = columnList.size();
            if (!formField.allowsMultipleValues() || formField.getPredefinedValues().isEmpty()) {
                columnList.add(new Column(formField, formField.getPredefinedValues().size() == 1, null));
                continue;
            }
            Iterator pvi = formField.getPredefinedValues().iterator();
            while (pvi.hasNext()) {
                columnList.add(new Column(formField, true, (String)pvi.next()));
            }
            if (formField.getUserValueCount() <= 0) continue;
            columnList.add(new Column(formField, false, null));
        }
        this.columns = columnList.toArray(new Column[columnList.size()]);
    }

    public List getFormControls() {
        return this.formControls;
    }

    public void merge(FormFields formFields) {
        Iterator i = formFields.iterator();
        while (i.hasNext()) {
            FormField formField = (FormField)i.next();
            String fieldName = formField.getName();
            FormField existingFormField = this.get(fieldName);
            if (existingFormField == null) {
                this.add(formField);
                continue;
            }
            existingFormField.merge(formField);
        }
    }

    public String getDebugInfo() {
        StringBuffer sb = new StringBuffer();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            sb.append(i.next());
        }
        return sb.toString();
    }

    public String toString() {
        return this.getDebugInfo();
    }

    void add(FormControl formControl) {
        this.add(formControl, formControl.getPredefinedValue());
    }

    void add(FormControl formControl, String predefinedValue) {
        this.add(formControl, predefinedValue, formControl.name);
    }

    void addName(FormControl formControl, String fieldName) {
        this.add(formControl, null, fieldName);
    }

    void add(FormControl formControl, String predefinedValue, String fieldName) {
        FormField formField;
        if (Config.CurrentCompatibilityMode.isFormFieldNameCaseInsensitive()) {
            fieldName = fieldName.toLowerCase();
        }
        if ((formField = (FormField)this.map.get(fieldName)) == null) {
            formField = new FormField(fieldName);
            this.add(formField);
        }
        formField.addFormControl(formControl, predefinedValue);
    }

    void addToOutputDocument(OutputDocument outputDocument) {
        Iterator i = ((AbstractList)this.formControls).iterator();
        while (i.hasNext()) {
            outputDocument.add((FormControl)i.next());
        }
    }

    private void add(FormField formField) {
        this.map.put(formField.getName(), formField);
    }

    private static class Column {
        public FormField formField;
        public boolean isBoolean;
        public String predefinedValue;

        public Column(FormField formField, boolean isBoolean, String predefinedValue) {
            this.formField = formField;
            this.isBoolean = isBoolean;
            this.predefinedValue = predefinedValue;
        }
    }
}

