/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.FormControl;
import au.id.jericho.lib.html.FormFields;
import au.id.jericho.lib.html.OutputSegment;
import au.id.jericho.lib.html.OverlappingOutputSegmentsException;
import au.id.jericho.lib.html.Util;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public final class OutputDocument {
    private CharSequence sourceText;
    private ArrayList outputSegments = new ArrayList();

    public OutputDocument(CharSequence sourceText) {
        if (sourceText == null) {
            throw new IllegalArgumentException("sourceText argument must not be null");
        }
        this.sourceText = sourceText;
    }

    public CharSequence getSourceText() {
        return this.sourceText;
    }

    public void add(OutputSegment outputSegment) {
        this.outputSegments.add(outputSegment);
    }

    public void add(FormControl formControl) {
        formControl.addToOutputDocument(this);
    }

    public void add(FormFields formFields) {
        formFields.addToOutputDocument(this);
    }

    public void output(Writer writer) throws IOException {
        if (this.outputSegments.isEmpty()) {
            Util.appendTo(writer, this.sourceText);
            return;
        }
        int pos = 0;
        Collections.sort(this.outputSegments, OutputSegment.COMPARATOR);
        OutputSegment lastOutputSegment = null;
        Iterator i = ((AbstractList)this.outputSegments).iterator();
        while (i.hasNext()) {
            OutputSegment outputSegment = (OutputSegment)i.next();
            if (outputSegment == lastOutputSegment) continue;
            if (outputSegment.getBegin() < pos) {
                throw new OverlappingOutputSegmentsException(lastOutputSegment, outputSegment);
            }
            if (outputSegment.getBegin() > pos) {
                Util.appendTo(writer, this.sourceText, pos, outputSegment.getBegin());
            }
            outputSegment.output(writer);
            lastOutputSegment = outputSegment;
            pos = outputSegment.getEnd();
        }
        if (pos < this.sourceText.length()) {
            Util.appendTo(writer, this.sourceText, pos, this.sourceText.length());
        }
        writer.close();
    }

    public String toString() {
        StringWriter writer = new StringWriter((int)((double)this.sourceText.length() * 1.5));
        try {
            this.output(writer);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return writer.toString();
    }

    public Reader getReader() {
        return new StringReader(this.toString());
    }
}

