/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Attributes;
import au.id.jericho.lib.html.EndTagType;
import au.id.jericho.lib.html.ParseText;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StartTagType;
import au.id.jericho.lib.html.Tag;

public class StartTagTypeGenericImplementation
extends StartTagType {
    final boolean nameCharAfterPrefixAllowed = this.getNamePrefix().length() == 0 || !Character.isLetter(this.getNamePrefix().charAt(this.getNamePrefix().length() - 1));

    protected StartTagTypeGenericImplementation(String description, String startDelimiter, String closingDelimiter, EndTagType correspondingEndTagType, boolean isServerTag) {
        this(description, startDelimiter, closingDelimiter, correspondingEndTagType, isServerTag, false, false);
    }

    protected StartTagTypeGenericImplementation(String description, String startDelimiter, String closingDelimiter, EndTagType correspondingEndTagType, boolean isServerTag, boolean hasAttributes, boolean isNameAfterPrefixRequired) {
        super(description, startDelimiter, closingDelimiter, correspondingEndTagType, isServerTag, hasAttributes, isNameAfterPrefixRequired);
    }

    protected Tag constructTagAt(Source source, int pos) {
        int end;
        ParseText parseText = source.getParseText();
        int nameBegin = pos + 1;
        String name = this.getNamePrefix();
        int nameEnd = nameBegin + this.getNamePrefix().length();
        if (this.isNameAfterPrefixRequired()) {
            int extendedNameEnd = source.findNameEnd(nameEnd);
            if (extendedNameEnd == -1) {
                return null;
            }
            name = parseText.substring(nameBegin, extendedNameEnd);
            nameEnd = extendedNameEnd;
        } else if (!this.nameCharAfterPrefixAllowed && Tag.isXMLNameChar(parseText.charAt(nameEnd))) {
            return null;
        }
        Attributes attributes = null;
        if (this.hasAttributes()) {
            attributes = this.parseAttributes(source, pos, name);
            if (attributes == null) {
                return null;
            }
            end = this.findEnd(source, attributes.getEnd());
        } else {
            end = this.findEnd(source, nameEnd);
            if (end == -1) {
                source.log("StartTag", name, pos, "not recognised as type '", this.getDescription(), "' because it has no closing delimiter", -1);
                return null;
            }
        }
        return this.constructStartTag(source, pos, end, name, attributes);
    }

    protected int findEnd(Source source, int pos) {
        int delimiterBegin = source.getParseText().indexOf(this.getClosingDelimiter(), pos);
        return delimiterBegin == -1 ? -1 : delimiterBegin + this.getClosingDelimiter().length();
    }
}

